/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class IndirectHashCollection<K, R> {
    private static final Map<IndirectHashCollection<?, ?>, Supplier<Collection<?>>> DIRECT_CACHES = new HashMap();
    private static final Map<IndirectHashCollection<?, ?>, Supplier<RecipeType<?>>> RECIPE_CACHES = new HashMap();
    private final Map<K, Collection<R>> indirectResultMap;
    private final Function<R, Iterable<? extends K>> keyExtractor;

    public static <K, R> IndirectHashCollection<K, R> create(Function<R, Iterable<? extends K>> keyExtractor, Supplier<Collection<R>> reloadableCollection) {
        IndirectHashCollection<? extends K, R> cache = new IndirectHashCollection<K, R>(keyExtractor);
        DIRECT_CACHES.put(cache, reloadableCollection);
        return cache;
    }

    public static <C extends Container, K, R extends Recipe<C>> IndirectHashCollection<K, R> createForRecipe(Function<R, Iterable<? extends K>> keyExtractor, Supplier<RecipeType<R>> recipeType) {
        IndirectHashCollection<? extends K, R> cache = new IndirectHashCollection<K, R>(keyExtractor);
        RECIPE_CACHES.put(cache, recipeType);
        return cache;
    }

    public static void reloadAllCaches(RecipeManager manager) {
        DIRECT_CACHES.forEach((cache, values) -> IndirectHashCollection.reloadDirectCache(cache, values));
        RECIPE_CACHES.forEach((cache, type) -> IndirectHashCollection.reloadRecipeCache(cache, manager, type));
    }

    private static <K, R> void reloadDirectCache(IndirectHashCollection<K, R> cache, Supplier<Collection<R>> values) {
        cache.reload(values.get());
    }

    private static <C extends Container, K, R extends Recipe<C>> void reloadRecipeCache(IndirectHashCollection<K, R> cache, RecipeManager manager, Supplier<RecipeType<R>> recipe) {
        cache.reload(Helpers.getRecipes(manager, recipe).values());
    }

    public IndirectHashCollection(Function<R, Iterable<? extends K>> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.indirectResultMap = new HashMap<K, Collection<R>>();
    }

    public Collection<R> getAll(K key) {
        return this.indirectResultMap.getOrDefault(key, Collections.emptyList());
    }

    public void reload(Collection<R> values) {
        this.indirectResultMap.clear();
        values.forEach(result -> {
            for (K directKey : this.keyExtractor.apply(result)) {
                this.indirectResultMap.computeIfAbsent(directKey, k -> new ArrayList()).add(result);
            }
        });
    }
}

