/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import java.util.Set;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredients;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class Support {
    public static final DataManager<Support> MANAGER = new DataManager<Support>(Helpers.identifier("supports"), "support", Support::new, Support::new, Support::encode, Packet::new);
    public static final IndirectHashCollection<Block, Support> CACHE = IndirectHashCollection.create(s -> s.ingredient.getValidBlocks(), MANAGER::getValues);
    private static SupportRange RANGE = new SupportRange(0, 0, 0);
    private final ResourceLocation id;
    private final BlockIngredient ingredient;
    private final int supportUp;
    private final int supportDown;
    private final int supportHorizontal;

    public static Set<BlockPos> findUnsupportedPositions(BlockGetter worldIn, BlockPos from, BlockPos to) {
        HashSet<BlockPos> listSupported = new HashSet<BlockPos>();
        HashSet<BlockPos> listUnsupported = new HashSet<BlockPos>();
        int minX = Math.min(from.m_123341_(), to.m_123341_());
        int maxX = Math.max(from.m_123341_(), to.m_123341_());
        int minY = Math.min(from.m_123342_(), to.m_123342_());
        int maxY = Math.max(from.m_123342_(), to.m_123342_());
        int minZ = Math.min(from.m_123343_(), to.m_123343_());
        int maxZ = Math.max(from.m_123343_(), to.m_123343_());
        for (BlockPos searchingPoint : Support.getMaximumSupportedAreaAround(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ))) {
            BlockState supportState;
            Support support;
            if (!listSupported.contains(searchingPoint)) {
                listUnsupported.add(searchingPoint.m_7949_());
            }
            if ((support = Support.get(supportState = worldIn.m_8055_(searchingPoint))) == null) continue;
            for (BlockPos supported : support.getSupportedArea(searchingPoint)) {
                listSupported.add(supported.m_7949_());
                listUnsupported.remove(supported);
            }
        }
        listUnsupported.removeIf(content -> content.m_123341_() < minX || content.m_123341_() > maxX || content.m_123342_() < minY || content.m_123342_() > maxY || content.m_123343_() < minZ || content.m_123343_() > maxZ);
        return listUnsupported;
    }

    public static boolean isSupported(BlockGetter world, BlockPos pos) {
        for (BlockPos supportPos : Support.getMaximumSupportedAreaAround(pos, pos)) {
            BlockState supportState = world.m_8055_(supportPos);
            Support support = Support.get(supportState);
            if (support == null || !support.canSupport(supportPos, pos)) continue;
            return true;
        }
        return false;
    }

    public static Iterable<BlockPos> getMaximumSupportedAreaAround(BlockPos minPoint, BlockPos maxPoint) {
        return BlockPos.m_121940_((BlockPos)minPoint.m_142082_(-RANGE.horizontal(), -RANGE.down(), -RANGE.horizontal()), (BlockPos)maxPoint.m_142082_(RANGE.horizontal(), RANGE.up(), RANGE.horizontal()));
    }

    @Nullable
    public static Support get(BlockState state) {
        for (Support support : CACHE.getAll(state.m_60734_())) {
            if (!support.matches(state)) continue;
            return support;
        }
        return null;
    }

    public static void updateMaximumSupportRange() {
        int up = 0;
        int down = 0;
        int horizontal = 0;
        for (Support support : MANAGER.getValues()) {
            up = Math.max(support.getSupportUp(), up);
            down = Math.max(support.getSupportDown(), down);
            horizontal = Math.max(support.getSupportHorizontal(), horizontal);
        }
        RANGE = new SupportRange(up, down, horizontal);
    }

    public Support(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.ingredient = BlockIngredients.fromJson(JsonHelpers.get(json, "ingredient"));
        this.supportUp = GsonHelper.m_13824_((JsonObject)json, (String)"support_up", (int)0);
        this.supportDown = GsonHelper.m_13824_((JsonObject)json, (String)"support_down", (int)0);
        this.supportHorizontal = GsonHelper.m_13824_((JsonObject)json, (String)"support_horizontal", (int)0);
        if (this.supportUp < 0 || this.supportDown < 0 || this.supportHorizontal < 0) {
            throw new JsonParseException("Support values must be nonnegative.");
        }
    }

    private Support(ResourceLocation id, FriendlyByteBuf buffer) {
        this.id = id;
        this.ingredient = BlockIngredients.fromNetwork(buffer);
        this.supportUp = buffer.m_130242_();
        this.supportDown = buffer.m_130242_();
        this.supportHorizontal = buffer.m_130242_();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getSupportUp() {
        return this.supportUp;
    }

    public int getSupportDown() {
        return this.supportDown;
    }

    public int getSupportHorizontal() {
        return this.supportHorizontal;
    }

    public boolean matches(BlockState state) {
        return this.ingredient.test(state);
    }

    public boolean canSupport(BlockPos supportPos, BlockPos testPos) {
        BlockPos diff = supportPos.m_141950_((Vec3i)testPos);
        return Math.abs(diff.m_123341_()) <= this.supportHorizontal && -this.supportDown <= diff.m_123342_() && diff.m_123342_() <= this.supportUp && Math.abs(diff.m_123343_()) <= this.supportHorizontal;
    }

    public Iterable<BlockPos> getSupportedArea(BlockPos center) {
        return BlockPos.m_121940_((BlockPos)center.m_142082_(-this.supportHorizontal, -this.supportDown, -this.supportHorizontal), (BlockPos)center.m_142082_(this.supportHorizontal, this.supportUp, this.supportHorizontal));
    }

    private void encode(FriendlyByteBuf buffer) {
        this.ingredient.toNetwork(buffer);
        buffer.m_130130_(this.supportUp);
        buffer.m_130130_(this.supportDown);
        buffer.m_130130_(this.supportHorizontal);
    }

    public record SupportRange(int up, int down, int horizontal) {
    }

    public static class Packet
    extends DataManagerSyncPacket<Support> {
    }
}

