/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.BlockDefinition;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Pannable
extends BlockDefinition {
    public static final DataManager<Pannable> MANAGER = new DataManager<Pannable>(Helpers.identifier("panning"), "panning", Pannable::new, Pannable::new, Pannable::encode, Packet::new);
    public static final IndirectHashCollection<Block, Pannable> CACHE = IndirectHashCollection.create(s -> s.ingredient.getValidBlocks(), MANAGER::getValues);
    private final ResourceLocation lootTable;
    private final ResourceLocation[] modelStages;

    @Nullable
    public static Pannable get(BlockState state) {
        for (Pannable pannable : CACHE.getAll(state.m_60734_())) {
            if (!pannable.ingredient.test(state)) continue;
            return pannable;
        }
        return null;
    }

    public Pannable(ResourceLocation id, JsonObject json) {
        super(id, json);
        JsonArray array = JsonHelpers.m_13933_((JsonObject)json, (String)"model_stages");
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(array.size());
        for (JsonElement element : array) {
            list.add(new ResourceLocation(element.getAsString()));
        }
        this.modelStages = list.toArray(new ResourceLocation[0]);
        this.lootTable = new ResourceLocation(JsonHelpers.m_13906_((JsonObject)json, (String)"loot_table"));
    }

    public Pannable(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        int size = buffer.m_130242_();
        this.modelStages = new ResourceLocation[size];
        for (int i = 0; i < size; ++i) {
            this.modelStages[i] = new ResourceLocation(buffer.m_130277_());
        }
        this.lootTable = new ResourceLocation(buffer.m_130277_());
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.modelStages.length);
        for (ResourceLocation res : this.modelStages) {
            buffer.m_130070_(res.toString());
        }
        buffer.m_130070_(this.lootTable.toString());
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public ResourceLocation[] getModelStages() {
        return this.modelStages;
    }

    public static class Packet
    extends DataManagerSyncPacket<Pannable> {
    }
}

