/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.recipes.ingredients.DelegateIngredient;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidItemIngredient
extends DelegateIngredient {
    private final FluidStackIngredient fluid;

    public FluidItemIngredient(@Nullable Ingredient delegate, FluidStackIngredient fluid) {
        super(delegate);
        this.fluid = fluid;
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        if (super.test(stack) && stack != null && !stack.m_41619_()) {
            return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).filter(this.fluid).isPresent();
        }
        return false;
    }

    @Override
    public IIngredientSerializer<? extends DelegateIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    protected ItemStack[] getDefaultItems() {
        return (ItemStack[])this.fluid.ingredient().getMatchingFluids().stream().flatMap(fluid -> Helpers.streamAllTagValues(TFCTags.Items.FLUID_ITEM_INGREDIENT_EMPTY_CONTAINERS, ForgeRegistries.ITEMS).map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            IFluidHandlerItem fluidHandler = Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
            if (fluidHandler != null) {
                fluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
                FluidStack content = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (content.getFluid() == fluid && content.getAmount() >= this.fluid.amount()) {
                    return fluidHandler.getContainer();
                }
            }
            return null;
        })).filter(Objects::nonNull).toArray(ItemStack[]::new);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.add("fluid_ingredient", this.fluid.toJson());
        return json;
    }

    public static enum Serializer implements IIngredientSerializer<FluidItemIngredient>
    {
        INSTANCE;


        public FluidItemIngredient parse(FriendlyByteBuf buffer) {
            Ingredient internal = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
            FluidStackIngredient fluid = FluidStackIngredient.fromNetwork(buffer);
            return new FluidItemIngredient(internal, fluid);
        }

        public FluidItemIngredient parse(JsonObject json) {
            Ingredient internal = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient")) : null;
            FluidStackIngredient fluid = FluidStackIngredient.fromJson(json.getAsJsonObject("fluid_ingredient"));
            return new FluidItemIngredient(internal, fluid);
        }

        public void write(FriendlyByteBuf buffer, FluidItemIngredient ingredient) {
            Helpers.encodeNullable(ingredient.delegate, buffer, Ingredient::m_43923_);
            ingredient.fluid.toNetwork(buffer);
        }
    }
}

