/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.SimpleItemRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ScrapingRecipe
extends SimpleItemRecipe {
    public static final IndirectHashCollection<Item, ScrapingRecipe> CACHE = IndirectHashCollection.createForRecipe(SimpleItemRecipe::getValidItems, TFCRecipeTypes.SCRAPING);
    @Nullable
    private final ResourceLocation inputTexture;
    @Nullable
    private final ResourceLocation outputTexture;

    @Nullable
    public static ScrapingRecipe getRecipe(Level world, ItemStackInventory wrapper) {
        for (ScrapingRecipe recipe : CACHE.getAll(wrapper.getStack().m_41720_())) {
            if (!recipe.matches(wrapper, world)) continue;
            return recipe;
        }
        return null;
    }

    public ScrapingRecipe(ResourceLocation id, Ingredient ingredient, ItemStackProvider result, @Nullable ResourceLocation inputTexture, @Nullable ResourceLocation outputTexture) {
        super(id, ingredient, result);
        this.inputTexture = inputTexture;
        this.outputTexture = outputTexture;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.SCRAPING.get();
    }

    @Nullable
    public ResourceLocation getInputTexture() {
        return this.inputTexture;
    }

    @Nullable
    public ResourceLocation getOutputTexture() {
        return this.outputTexture;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.SCRAPING.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<ScrapingRecipe> {
        public ScrapingRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient"));
            ItemStackProvider result = ItemStackProvider.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ResourceLocation inputTexture = json.has("input_texture") ? new ResourceLocation(JsonHelpers.m_13906_((JsonObject)json, (String)"input_texture")) : null;
            ResourceLocation outputTexture = json.has("output_texture") ? new ResourceLocation(JsonHelpers.m_13906_((JsonObject)json, (String)"output_texture")) : null;
            return new ScrapingRecipe(id, ingredient, result, inputTexture, outputTexture);
        }

        @Nullable
        public ScrapingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStackProvider result = ItemStackProvider.fromNetwork(buffer);
            ResourceLocation inputTexture = Helpers.decodeNullable(buffer, b -> new ResourceLocation(b.m_130277_()));
            ResourceLocation outputTexture = Helpers.decodeNullable(buffer, b -> new ResourceLocation(b.m_130277_()));
            return new ScrapingRecipe(id, ingredient, result, inputTexture, outputTexture);
        }

        public void toNetwork(FriendlyByteBuf buffer, ScrapingRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            recipe.getResult().toNetwork(buffer);
            Helpers.encodeNullable(recipe.inputTexture, buffer, (r, b) -> b.m_130070_(r.toString()));
            Helpers.encodeNullable(recipe.outputTexture, buffer, (r, b) -> b.m_130070_(r.toString()));
        }
    }
}

