/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.TypedRecipeSerializer;
import net.dries007.tfc.util.KnappingPattern;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KnappingRecipe
implements ISimpleRecipe<KnappingContainer.Query> {
    protected final ResourceLocation id;
    protected final KnappingPattern pattern;
    protected final ItemStack result;
    protected final TypedRecipeSerializer<?> serializer;

    public KnappingRecipe(ResourceLocation id, KnappingPattern pattern, ItemStack result, TypedRecipeSerializer<?> serializer) {
        this.id = id;
        this.pattern = pattern;
        this.result = result;
        this.serializer = serializer;
    }

    public boolean matches(KnappingContainer.Query query, Level level) {
        return query.container().getPattern().matches(this.getPattern());
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public RecipeType<?> m_6671_() {
        return this.serializer.getRecipeType();
    }

    public KnappingPattern getPattern() {
        return this.pattern;
    }

    public static class Serializer
    extends TypedRecipeSerializer<KnappingRecipe> {
        private final Supplier<RecipeType<KnappingRecipe>> type;

        public Serializer(Supplier<RecipeType<KnappingRecipe>> type) {
            this.type = type;
        }

        public KnappingRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack stack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new KnappingRecipe(id, KnappingPattern.fromJson(json), stack, this);
        }

        @Nullable
        public KnappingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            KnappingPattern pattern = KnappingPattern.fromNetwork(buffer);
            ItemStack stack = buffer.m_130267_();
            return new KnappingRecipe(id, pattern, stack, this);
        }

        public void toNetwork(FriendlyByteBuf buffer, KnappingRecipe recipe) {
            recipe.getPattern().toNetwork(buffer);
            buffer.m_130055_(recipe.m_8043_());
        }

        @Override
        public RecipeType<?> getRecipeType() {
            return this.type.get();
        }
    }
}

