/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.items.ProspectResult;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.ProspectedPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.ProspectedEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class PropickItem
extends ToolItem {
    public static final int RADIUS = 12;
    private static final int COOLDOWN = 10;
    private static final Random RANDOM = new Random();
    private final float falseNegativeChance;

    public static Object2IntMap<BlockState> scanAreaFor(Level level, BlockPos center, int radius, TagKey<Block> tag) {
        Object2IntOpenHashMap results = new Object2IntOpenHashMap();
        for (BlockPos cursor : BlockPos.m_121976_((int)(center.m_123341_() - radius), (int)(center.m_123342_() - radius), (int)(center.m_123343_() - radius), (int)(center.m_123341_() + radius), (int)(center.m_123342_() + radius), (int)(center.m_123343_() + radius))) {
            BlockState state = level.m_8055_(cursor);
            if (!Helpers.isBlock(state, tag)) continue;
            results.mergeInt((Object)state, 1, Integer::sum);
        }
        return results;
    }

    public PropickItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, TFCTags.Blocks.MINEABLE_WITH_PROPICK, properties);
        this.falseNegativeChance = 0.3f - (float)Mth.m_14045_((int)tier.m_6604_(), (int)0, (int)5) * 0.060000002f;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (player instanceof ServerPlayer) {
            ArrayList stateKeys;
            int amount;
            Object2IntMap<BlockState> states;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundType sound = state.getSoundType((LevelReader)level, pos, (Entity)player);
            level.m_5594_(player, pos, sound.m_56778_(), SoundSource.PLAYERS, sound.m_56773_(), sound.m_56774_());
            context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            player.m_36335_().m_41524_((Item)this, 10);
            BlockState found = state;
            RANDOM.setSeed(Helpers.hash(19827384739241223L, pos));
            ProspectResult result = Helpers.isBlock(state, TFCTags.Blocks.PROSPECTABLE) ? ProspectResult.FOUND : (RANDOM.nextFloat() < this.falseNegativeChance ? ProspectResult.NOTHING : ((states = PropickItem.scanAreaFor(level, pos, 12, TFCTags.Blocks.PROSPECTABLE)).isEmpty() ? ProspectResult.NOTHING : ((amount = states.getOrDefault((Object)(found = (BlockState)(stateKeys = new ArrayList(states.keySet())).get(RANDOM.nextInt(stateKeys.size()))), 1)) < 10 ? ProspectResult.TRACES : (amount < 20 ? ProspectResult.SMALL : (amount < 40 ? ProspectResult.MEDIUM : (amount < 80 ? ProspectResult.LARGE : ProspectResult.VERY_LARGE))))));
            MinecraftForge.EVENT_BUS.post((Event)new ProspectedEvent(player, result, found.m_60734_()));
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), new ProspectedPacket(found.m_60734_(), result));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        if (flag.m_7050_()) {
            text.add((Component)Helpers.translatable("tfc.tooltip.propick.accuracy", (int)(100.0f * (1.0f - this.falseNegativeChance))).m_130940_(ChatFormatting.GRAY));
        }
    }
}

