/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.ItemStackFluidHandler;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidContainerItem
extends Item {
    protected final TagKey<Fluid> whitelist;
    protected final Supplier<Integer> capacity;
    private final boolean canPlaceLiquidsInWorld;
    private final boolean canPlaceSourceBlocks;

    public FluidContainerItem(Item.Properties properties, Supplier<Integer> capacity, TagKey<Fluid> whitelist, boolean canPlaceLiquidsInWorld, boolean canPlaceSourceBlocks) {
        super(properties);
        this.capacity = capacity;
        this.whitelist = whitelist;
        this.canPlaceLiquidsInWorld = canPlaceLiquidsInWorld;
        this.canPlaceSourceBlocks = canPlaceSourceBlocks;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult hit;
        ItemStack stack = player.m_21120_(hand);
        if (FluidHelpers.transferBetweenWorldAndItem(stack, level, hit = Helpers.rayTracePlayer(level, player, ClipContext.Fluid.SOURCE_ONLY), player, hand, this.canPlaceLiquidsInWorld, this.canPlaceSourceBlocks(), false)) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        IFluidHandler handler = (IFluidHandler)Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
        if (handler == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (handler.getFluidInTank(0).isEmpty()) {
            return this.afterFillFailed(handler, level, player, stack, hand);
        }
        return this.afterEmptyFailed(handler, level, player, stack, hand);
    }

    public Component m_7626_(ItemStack stack) {
        FluidStack fluid = stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (!fluid.isEmpty()) {
            return Helpers.translatable(this.m_5671_(stack) + ".filled", fluid.getDisplayName());
        }
        return super.m_7626_(stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        IFluidHandlerItem handler = Helpers.getCapability((ICapabilityProvider)Helpers.copyWithSize(stack, 1), Capabilities.FLUID_ITEM);
        if (handler != null && handler.getFluidInTank(0).isEmpty()) {
            return super.getItemStackLimit(stack);
        }
        return 1;
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (this.m_41389_(category)) {
            items.add((Object)new ItemStack((ItemLike)this));
            for (Fluid fluid : Helpers.getAllTagValues(this.whitelist, ForgeRegistries.FLUIDS)) {
                FlowingFluid flowing;
                if (fluid instanceof FlowingFluid && (flowing = (FlowingFluid)fluid).m_5613_() != flowing) continue;
                ItemStack stack = new ItemStack((ItemLike)this);
                stack.getCapability(Capabilities.FLUID_ITEM).ifPresent(c -> c.fill(new FluidStack(fluid, this.capacity.get().intValue()), IFluidHandler.FluidAction.EXECUTE));
                items.add((Object)stack);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag isAdvanced) {
        stack.getCapability(Capabilities.FLUID_ITEM).ifPresent(cap -> {
            FluidStack fluid = cap.getFluidInTank(0);
            if (!fluid.isEmpty() && fluid.getAmount() < this.capacity.get()) {
                tooltips.add((Component)Tooltips.fluidUnitsAndCapacityOf(fluid, this.capacity.get()));
            }
        });
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack((ItemLike)this);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> !cap.getFluidInTank(0).isEmpty()).orElse(false);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemStackFluidHandler(stack, this.whitelist, (int)this.capacity.get());
    }

    public boolean canPlaceSourceBlocks() {
        return this.canPlaceSourceBlocks && (Boolean)TFCConfig.SERVER.enableBucketsPlacingSources.get() != false;
    }

    public boolean canPlaceLiquidsInWorld() {
        return this.canPlaceLiquidsInWorld;
    }

    protected InteractionResultHolder<ItemStack> afterFillFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected InteractionResultHolder<ItemStack> afterEmptyFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

