/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.AnimationState;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.WildAnimal;
import net.dries007.tfc.common.entities.ai.PredicateMoveControl;
import net.dries007.tfc.common.entities.ai.TFCClimberNavigation;
import net.dries007.tfc.common.entities.ai.prey.PestAi;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Pest
extends Prey {
    public static final EntityDataAccessor<Boolean> DATA_CLIMBING = SynchedEntityData.m_135353_(Pest.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState sniffingAnimation = new AnimationState();
    public final AnimationState searchingAnimation = new AnimationState();
    public final AnimationState eatingAnimation = new AnimationState();
    public final AnimationState draggingAnimation = new AnimationState();
    private static final int DRAG_TIME = 200;
    private static final int EAT_TIME = 200;
    private int dragTicks = -1;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public Pest(EntityType<? extends Prey> type, Level level, TFCSounds.EntitySound sounds) {
        super((EntityType<? extends WildAnimal>)type, level, sounds);
        this.f_21342_ = new PredicateMoveControl<Pest>(this, p -> p.dragTicks == -1 || p.dragTicks > 400);
    }

    protected Brain.Provider<? extends Pest> m_5490_() {
        return Brain.m_21923_(PestAi.MEMORY_TYPES, PestAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return PestAi.makeBrain((Brain<? extends Pest>)this.m_5490_().m_22073_(dynamic));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLIMBING, (Object)false);
    }

    public void setClimbing(boolean climbing) {
        this.f_19804_.m_135381_(DATA_CLIMBING, (Object)climbing);
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CLIMBING);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    @Override
    public void m_8119_() {
        ItemStack held = this.m_21205_();
        if (!held.m_41619_() || this.eatingAnimation.isStarted()) {
            ++this.dragTicks;
            if (this.dragTicks < 200) {
                if (this.f_19853_.f_46443_) {
                    this.draggingAnimation.startIfStopped(this.f_19797_);
                }
            } else {
                if (this.f_19853_.f_46443_) {
                    this.draggingAnimation.stop();
                    this.eatingAnimation.startIfStopped(this.f_19797_);
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, held), this.m_20185_(), this.m_20188_(), this.m_20189_(), (double)Helpers.triangle(this.f_19796_), (double)(-this.f_19796_.nextFloat()), (double)Helpers.triangle(this.f_19796_));
                    if (this.f_19796_.nextInt(20) == 0) {
                        this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
                    }
                }
                if (this.dragTicks > 400) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (this.f_19853_.f_46443_) {
                        this.eatingAnimation.stop();
                    }
                    this.m_5496_(SoundEvents.f_12321_, this.m_6121_(), this.m_6100_());
                }
            }
        } else {
            this.dragTicks = -1;
        }
        if (this.f_19853_.f_46443_ && this.dragTicks == -1 && !EntityHelpers.isMovingOnLand((Entity)this) && this.f_19796_.nextInt(20) == 0) {
            if (this.f_19796_.nextBoolean()) {
                this.sniffingAnimation.startIfStopped(this.f_19797_);
                this.m_5496_(SoundEvents.f_11951_, this.m_6121_(), this.m_6100_());
            } else {
                this.searchingAnimation.startIfStopped(this.f_19797_);
                this.m_5496_(SoundEvents.f_11951_, this.m_6121_(), this.m_6100_());
            }
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (this.f_19797_ > 3600 && this.f_19796_.nextInt(500) == 0) {
            this.m_146870_();
        }
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new TFCClimberNavigation((Mob)this, level);
    }

    @Override
    public boolean m_6785_(double distance) {
        return true;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, type, data, tag);
        if (this.f_19796_.nextInt(1000) == 0) {
            this.m_6593_((Component)Helpers.literal("Pak"));
        }
        if (this.f_19796_.nextFloat() < 0.2f) {
            this.m_6863_(true);
        }
        return spawnData;
    }
}

