/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.predator;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.entities.AnimationState;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public class FelinePredator
extends Predator {
    public final AnimationState crouchingAnimation = new AnimationState();
    public final double crouchSpeedMod;
    public final double sprintSpeedMod;
    public final double attackDistanceSquared;

    public static FelinePredator createCougar(EntityType<? extends Predator> type, Level level) {
        return new FelinePredator(type, level, false, 36.0, 0.8, 1.5, TFCSounds.COUGAR);
    }

    public static FelinePredator createLion(EntityType<? extends Predator> type, Level level) {
        return new FelinePredator(type, level, false, 36.0, 0.8, 1.5, TFCSounds.LION);
    }

    public static FelinePredator createSabertooth(EntityType<? extends Predator> type, Level level) {
        return new FelinePredator(type, level, false, 36.0, 0.8, 1.5, TFCSounds.SABERTOOTH);
    }

    public FelinePredator(EntityType<? extends Predator> type, Level level, boolean diurnal, double attackDistanceSquared, double crouchSpeedMod, double sprintSpeedMod, TFCSounds.EntitySound sounds) {
        super(type, level, diurnal, sounds);
        this.crouchSpeedMod = crouchSpeedMod;
        this.sprintSpeedMod = sprintSpeedMod;
        this.attackDistanceSquared = attackDistanceSquared;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.5);
    }

    @Override
    public void tickAnimationStates() {
        if (this.m_5803_()) {
            if (this.m_21187_().nextInt(10) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)TFCParticles.SLEEP.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 0.01, 0.05, 0.01);
            }
            this.sleepingAnimation.startIfStopped(this.f_19797_);
        } else {
            this.sleepingAnimation.stop();
            if (this.swimmingAnimation.isStarted()) {
                EntityHelpers.startOrStop(this.swimmingAnimation, this.m_20069_(), this.f_19797_);
            } else {
                EntityHelpers.startOrStop(this.runningAnimation, this.m_5912_(), this.f_19797_);
                EntityHelpers.startOrStop(this.walkingAnimation, !this.m_5912_(), this.f_19797_);
            }
        }
    }
}

