/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.pet;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class TFCCat
extends TamableMammal {
    public static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.m_135353_(TFCCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public TFCCat(EntityType<? extends TamableMammal> type, Level level) {
        super(type, level, TFCSounds.CAT, TFCConfig.SERVER.catConfig);
    }

    @Override
    public boolean willListenTo(TamableMammal.Command command, boolean isClientSide) {
        if (!isClientSide && command == TamableMammal.Command.SIT && this.m_21187_().nextFloat() < 0.1f) {
            return false;
        }
        return super.willListenTo(command, isClientSide);
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        super.createGenes(tag, male);
        if (male instanceof TFCCat) {
            TFCCat maleCat = (TFCCat)male;
            tag.m_128405_("catType", this.f_19796_.nextBoolean() ? maleCat.getCatType() : this.getCatType());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties baby) {
        super.applyGenes(tag, baby);
        if (baby instanceof TFCCat) {
            TFCCat cat = (TFCCat)baby;
            cat.setCatType(EntityHelpers.getIntOrDefault(tag, "catType", this.f_19796_.nextInt(10)));
        }
    }

    @Override
    public boolean m_6779_(LivingEntity entity) {
        return super.m_6779_(entity) && Helpers.isEntity((Entity)entity, TFCTags.Entities.HUNTED_BY_CATS);
    }

    @Override
    public void initCommonAnimalData() {
        super.initCommonAnimalData();
        this.setCatType(this.f_19796_.nextInt(10));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE, (Object)0);
    }

    public int getCatType() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE);
    }

    public void setCatType(int type) {
        if (type < 0 || type >= 11) {
            type = this.f_19796_.nextInt(10);
        }
        this.f_19804_.m_135381_(DATA_TYPE, (Object)type);
    }

    public ResourceLocation getTextureLocation() {
        return Cat.f_28102_.getOrDefault(this.getCatType(), (ResourceLocation)Cat.f_28102_.get(0));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("CatType", this.getCatType());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCatType(tag.m_128451_("CatType"));
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.CAT_FOOD;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    @Override
    public void receiveCommand(ServerPlayer player, TamableMammal.Command command) {
        if (this.m_142480_() != null && this.m_142480_().equals((Object)player)) {
            this.m_5496_(SoundEvents.f_11793_, this.m_6121_(), this.m_6100_());
        }
        super.receiveCommand(player, command);
    }
}

