/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.pet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.FastGateBehavior;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.livestock.BreedBehavior;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.pet.FollowOwnerBehavior;
import net.dries007.tfc.common.entities.ai.pet.TamableFindSleepPos;
import net.dries007.tfc.common.entities.ai.pet.TamableSleepBehavior;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.common.entities.prey.Pest;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class TamableAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super TamableMammal>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26822_, (Object)SensorType.f_26814_, (Object)((SensorType)TFCBrain.TEMPTATION_SENSOR.get()));
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26328_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_26331_, (Object)MemoryModuleType.f_148197_, (Object)MemoryModuleType.f_148198_, (Object)MemoryModuleType.f_26383_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26382_, MemoryModuleType.f_26381_, MemoryModuleType.f_26359_, (MemoryModuleType)TFCBrain.SLEEP_POS.get(), (MemoryModuleType)TFCBrain.SIT_TIME.get(), MemoryModuleType.f_26372_, MemoryModuleType.f_26373_});
    public static final int HOME_WANDER_DISTANCE = 36;
    public static final int HOME_LOST_DISTANCE = 120;

    public static Brain<?> makeBrain(Brain<? extends TamableMammal> brain) {
        TamableAi.initCoreActivity(brain);
        TamableAi.initIdleActivity(brain);
        TamableAi.initIdleAtHomeActivity(brain);
        TamableAi.initRestActivity(brain);
        TamableAi.initRetreatActivity(brain);
        TamableAi.initFollowActivity(brain);
        TamableAi.initHuntActivity(brain);
        TamableAi.initFightActivity(brain);
        TamableAi.initSitActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new RunIf(e -> !e.m_5803_(), (Behavior)new MoveToTargetSink(), true), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    public static void initIdleActivity(Brain<? extends TamableMammal> brain) {
        LivestockAi.initIdleActivity(brain);
    }

    public static void initIdleAtHomeActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21900_((Activity)TFCBrain.IDLE_AT_HOME.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)((Object)new BreedBehavior(0.5f))), (Object)Pair.of((Object)1, (Object)new AnimalPanic(1.0f)), (Object)Pair.of((Object)2, (Object)new FollowTemptation(e -> Float.valueOf(e.m_6162_() ? 1.5f : 1.25f))), (Object)Pair.of((Object)3, (Object)new BabyFollowAdult(UniformInt.m_146622_((int)5, (int)16), 1.25f)), (Object)Pair.of((Object)3, (Object)new RunIf(TamableAi::isTooFarFromHome, (Behavior)new StrollToPoi(MemoryModuleType.f_26359_, 1.0f, 10, 26))), (Object)Pair.of((Object)3, (Object)new StartAttacking(TamableAi::getUnwantedAttackTarget)), (Object)Pair.of((Object)4, FastGateBehavior.runOne(ImmutableList.of((Object)new StrollToPoi(MemoryModuleType.f_26359_, 0.6f, 10, 26), (Object)new StrollAroundPoi(MemoryModuleType.f_26359_, 0.6f, 36), (Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)new DoNothing(30, 60))))));
    }

    public static void initRestActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21891_(Activity.f_37982_, 10, ImmutableList.of((Object)new RunIf(e -> !e.m_5803_() && TamableAi.isTooFarFromHome(e), (Behavior)new StrollToPoi(MemoryModuleType.f_26359_, 1.2f, 5, 36)), (Object)new RunIf(e -> !e.m_5803_(), (Behavior)new TamableFindSleepPos()), (Object)((Object)new TamableSleepBehavior())));
    }

    public static void initRetreatActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.3f, (int)15, (boolean)false), TamableAi.createIdleMovementBehaviors(), (Object)new RunSometimes((Behavior)new SetEntityLookTarget(8.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)new EraseMemoryIf(PreyAi::wantsToStopFleeing, MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    public static void initHuntActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21900_((Activity)TFCBrain.HUNT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FollowOwnerBehavior())), (Object)Pair.of((Object)1, (Object)new StartAttacking(TamableAi::getAttackTarget)), (Object)Pair.of((Object)4, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60)))));
    }

    public static void initFightActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.15f), (Object)new MeleeAttack(40), (Object)new StopAttackingIfTargetInvalid(e -> TamableAi.couldFlee(e), TamableMammal::refreshCommandOnNextTick)), MemoryModuleType.f_26372_);
    }

    public static void initFollowActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21900_((Activity)TFCBrain.FOLLOW.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FollowOwnerBehavior())), (Object)Pair.of((Object)1, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60)))));
    }

    public static void initSitActivity(Brain<? extends TamableMammal> brain) {
        brain.m_21900_((Activity)TFCBrain.SIT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(MobCategory.CREATURE, 8.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 8.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)2, (Object)new DoNothing(30, 60))));
    }

    public static FastGateBehavior<TFCAnimal> createIdleMovementBehaviors() {
        return LivestockAi.createIdleMovementBehaviors();
    }

    public static boolean isTooFarFromHome(TamableMammal entity) {
        return TamableAi.isFarFromHome(entity, 36);
    }

    public static boolean isExtremelyFarFromHome(TamableMammal entity) {
        return TamableAi.isFarFromHome(entity, 120);
    }

    public static boolean isFarFromHome(TamableMammal entity, int distance) {
        return entity.m_6274_().m_21952_(MemoryModuleType.f_26359_).map(globalPos -> globalPos.m_122640_() != entity.f_19853_.m_46472_() || globalPos.m_122646_().m_123331_((Vec3i)entity.m_142538_()) > (double)(distance * distance)).orElse(true);
    }

    public static boolean wantsToStopSitting(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.m_6274_();
        if (brain.m_21952_(MemoryModuleType.f_26382_).isPresent()) {
            return true;
        }
        return brain.m_21952_((MemoryModuleType)TFCBrain.SIT_TIME.get()).filter(time -> Calendars.SERVER.getTicks() > time + 2000L).isPresent();
    }

    public static boolean wantsToStopSleeping(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.m_6274_();
        if (brain.m_21952_(MemoryModuleType.f_26382_).isPresent()) {
            return true;
        }
        return brain.m_21952_(MemoryModuleType.f_26328_).filter(time -> Calendars.SERVER.getTicks() > time + 2000L).isPresent();
    }

    public static void updateActivity(TamableMammal entity, boolean doMoreChecks) {
        Brain<? extends TamableMammal> brain = entity.m_6274_();
        Activity current = brain.m_21968_().orElse(null);
        if (current != null) {
            if (brain.m_21874_(MemoryModuleType.f_26383_) && TamableAi.couldFlee((LivingEntity)entity)) {
                brain.m_21889_(Activity.f_37991_);
                return;
            }
            if (brain.m_21874_(MemoryModuleType.f_26372_)) {
                brain.m_21889_(Activity.f_37988_);
            }
            if (doMoreChecks) {
                entity.setInterested(brain.m_21952_(MemoryModuleType.f_26371_).filter(lookTarget -> {
                    EntityTracker entityTracker;
                    return lookTarget instanceof EntityTracker && entity.isOwnedBy((entityTracker = (EntityTracker)lookTarget).m_147481_()) && entity.isSitting() && entityTracker.m_6826_((LivingEntity)entity);
                }).isPresent());
                boolean farFromHome = TamableAi.isExtremelyFarFromHome(entity);
                if ((current.equals(TFCBrain.HUNT.get()) || current.equals(TFCBrain.FOLLOW.get())) && entity.m_142480_() == null) {
                    TamableAi.beginIdle(entity, !farFromHome);
                } else if (current.equals(TFCBrain.IDLE_AT_HOME.get())) {
                    if (farFromHome) {
                        TamableAi.beginIdle(entity, false);
                    } else {
                        brain.m_21952_(MemoryModuleType.f_26328_).ifPresentOrElse(slept -> {
                            if (Calendars.SERVER.getTicks() > slept + 12000L) {
                                brain.m_21889_(Activity.f_37982_);
                            }
                        }, () -> brain.m_21879_(MemoryModuleType.f_26328_, (Object)0L));
                    }
                } else if (current.equals(TFCBrain.SIT.get()) && TamableAi.wantsToStopSitting(entity)) {
                    TamableAi.beginIdle(entity, !farFromHome);
                } else if (current.equals((Object)Activity.f_37982_) && entity.m_5803_() && TamableAi.wantsToStopSleeping(entity)) {
                    TamableAi.beginIdle(entity, !farFromHome);
                }
            }
        }
    }

    private static void beginIdle(TamableMammal entity, boolean home) {
        entity.setSitting(false);
        entity.setSleeping(false);
        entity.setCommand(TamableMammal.Command.RELAX);
        entity.m_6274_().m_21889_(home ? (Activity)TFCBrain.IDLE_AT_HOME.get() : Activity.f_37979_);
    }

    private static boolean couldFlee(LivingEntity entity) {
        return entity.m_21223_() < 5.0f || entity.m_6060_();
    }

    private static Optional<? extends LivingEntity> getUnwantedAttackTarget(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26382_)) {
            return brain.m_21952_(MemoryModuleType.f_26382_);
        }
        return brain.m_21952_(MemoryModuleType.f_148205_).flatMap(memory -> memory.m_186116_(e -> e instanceof Pest));
    }

    private static Optional<? extends LivingEntity> getAttackTarget(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.m_6274_();
        if (TamableAi.couldFlee((LivingEntity)entity)) {
            return Optional.empty();
        }
        Entity entity2 = entity.m_142480_();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            LivingEntity target = player.m_142581_();
            if (target != null && entity.m_6779_(target) && target.f_19797_ < player.m_21213_() + 120) {
                return Optional.of(target);
            }
            target = player.m_21214_();
            if (target != null && entity.m_6779_(target) && target.f_19797_ < player.m_21215_() + 120) {
                return Optional.of(target);
            }
        }
        if (brain.m_21874_(MemoryModuleType.f_26382_)) {
            return brain.m_21952_(MemoryModuleType.f_26382_);
        }
        return Optional.empty();
    }
}

