/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.capabilities.forge.ForgingCapability;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AnvilContainer
extends BlockEntityContainer<AnvilBlockEntity>
implements ButtonHandlerContainer {
    public static final int PLAN_ID = 8;

    public static AnvilContainer create(AnvilBlockEntity anvil, Inventory playerInv, int windowId) {
        return (AnvilContainer)new AnvilContainer(windowId, anvil).init(playerInv, 41);
    }

    protected AnvilContainer(int windowId, AnvilBlockEntity anvil) {
        super((MenuType)TFCContainerTypes.ANVIL.get(), windowId, anvil);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        if (buttonID == 8) {
            Player player;
            ItemStack stack;
            Level level = ((AnvilBlockEntity)this.blockEntity).m_58904_();
            if (level != null && AnvilRecipe.hasAny(level, stack = this.m_38853_(0).m_7993_(), ((AnvilBlockEntity)this.blockEntity).getTier()) && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen(serverPlayer, ((AnvilBlockEntity)this.blockEntity).planProvider(), ((AnvilBlockEntity)this.blockEntity).m_58899_());
            }
        } else {
            ForgeStep step = ForgeStep.valueOf(buttonID);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (step != null) {
                    ((AnvilBlockEntity)this.blockEntity).work(serverPlayer, step);
                }
            }
        }
    }

    @Override
    protected void addContainerSlots() {
        ((AnvilBlockEntity)this.blockEntity).getCapability(Capabilities.ITEM).ifPresent(handler -> {
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, 0, 31, 68));
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, 1, 13, 68));
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, 2, 129, 68));
            this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, 3, 147, 68));
        });
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, 2, 4, false) && !this.m_38903_(stack, 0, 2, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> {
                boolean result;
                Level level = ((AnvilBlockEntity)this.blockEntity).m_58904_();
                Forging forge = ForgingCapability.get(stack);
                AnvilRecipe recipe = null;
                int target = -1;
                if (forge != null && level != null) {
                    recipe = forge.getRecipe(level);
                    target = forge.getWorkTarget();
                    forge.clearRecipeIfNotWorked();
                }
                boolean v1 = result = !this.m_38903_(stack, this.containerSlots, this.f_38839_.size(), false);
                if (!stack.m_41619_() && recipe != null) {
                    forge.setRecipe(recipe, target);
                }
                yield result;
            }
        };
    }
}

