/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class DeviceBlock
extends ExtendedBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final InventoryRemoveBehavior removeBehavior;

    public DeviceBlock(ExtendedProperties properties, InventoryRemoveBehavior removeBehavior) {
        super(properties);
        this.removeBehavior = removeBehavior;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            if (!Helpers.isBlock(state, newState.m_60734_())) {
                this.beforeRemove(inv);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity entity = level.m_7702_(pos);
        if (stack.m_41788_() && entity instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            inv.setCustomName(stack.m_41786_());
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity entity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        if (this.removeBehavior == InventoryRemoveBehavior.SAVE && (entity = level.m_7702_(pos)) instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            inv.m_187476_(stack);
        }
        return stack;
    }

    protected void beforeRemove(InventoryBlockEntity<?> entity) {
        if (this.removeBehavior == InventoryRemoveBehavior.DROP) {
            entity.ejectInventory();
        }
        entity.invalidateCapabilities();
    }

    protected static enum InventoryRemoveBehavior {
        NOOP,
        DROP,
        SAVE;

    }
}

