/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThatchBlock
extends Block
implements IForgeBlockExtension,
IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    private final ExtendedProperties properties;

    public ThatchBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.f_76191_)));
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return level.m_7469_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid() == Fluids.f_76191_) {
            Helpers.slowEntityInBlock(entity, ((Double)TFCConfig.SERVER.thatchMovementMultiplier.get()).floatValue(), 5);
        }
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.m_76152_()));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FLUID}));
    }
}

