/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.dries007.tfc.common.container.NestBoxContainer;
import net.dries007.tfc.common.entities.Seat;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class NestBoxBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 4;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.nest_box");

    public static void serverTick(Level level, BlockPos pos, BlockState state, NestBoxBlockEntity nest) {
        nest.checkForLastTickSync();
        if (level.m_46467_() % 30L == 0L) {
            Entity sitter = Seat.getSittingEntity(level, pos);
            if (sitter instanceof OviparousAnimal) {
                OviparousAnimal bird = (OviparousAnimal)sitter;
                if (bird.isReadyForAnimalProduct()) {
                    if (bird.m_21187_().nextInt(7) == 0) {
                        Helpers.playSound(level, pos, SoundEvents.f_11752_);
                        if (Helpers.insertOne(level, pos, (BlockEntityType<? extends BlockEntity>)((BlockEntityType)TFCBlockEntities.NEST_BOX.get()), bird.makeEgg())) {
                            bird.setFertilized(false);
                            bird.setProductsCooldown();
                            bird.m_8127_();
                            nest.markForSync();
                        }
                    }
                } else {
                    bird.m_8127_();
                }
            }
            int i = 0;
            while (i < ((ItemStackHandler)nest.inventory).getSlots()) {
                int slot = i++;
                ItemStack stack = ((ItemStackHandler)nest.inventory).getStackInSlot(slot);
                stack.getCapability(EggCapability.CAPABILITY).filter(IEgg::isFertilized).ifPresent(egg -> {
                    if (egg.getHatchDay() > 0L && egg.getHatchDay() <= Calendars.SERVER.getTotalDays()) {
                        egg.getEntity(level).ifPresent(entity -> {
                            entity.m_20035_(pos, 0.0f, 0.0f);
                            level.m_7967_(entity);
                        });
                        ((ItemStackHandler)nest.inventory).setStackInSlot(slot, ItemStack.f_41583_);
                    }
                });
            }
        }
    }

    public NestBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.NEST_BOX.get(), pos, state, NestBoxBlockEntity.defaultInventory(4), NAME);
        if (((Boolean)TFCConfig.SERVER.nestBoxEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).extractAll(), Direction.DOWN);
        }
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.mightHaveCapability(stack, EggCapability.CAPABILITY);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
        return NestBoxContainer.create(this, inv, windowID);
    }
}

