/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.client.screen.button.AnvilPlanButton;
import net.dries007.tfc.client.screen.button.AnvilStepButton;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.capabilities.forge.ForgeRule;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.ForgeSteps;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public class AnvilScreen
extends BlockEntityScreen<AnvilBlockEntity, AnvilContainer> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/anvil.png");

    public AnvilScreen(AnvilContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 41;
        this.f_97727_ += 41;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new AnvilPlanButton((AnvilBlockEntity)this.blockEntity, this.getGuiLeft(), this.getGuiTop(), RenderHelpers.makeButtonTooltip((Screen)this, (Component)Helpers.translatable("tfc.tooltip.anvil_plan"))));
        for (ForgeStep step : ForgeStep.VALUES) {
            this.m_142416_((GuiEventListener)new AnvilStepButton(step, this.getGuiLeft(), this.getGuiTop(), RenderHelpers.makeButtonTooltip((Screen)this, (Component)Helpers.translateEnum(step))));
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        Level level = ((AnvilBlockEntity)this.blockEntity).m_58904_();
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        assert (level != null);
        Forging forging = ((AnvilBlockEntity)this.blockEntity).getMainInputForging();
        if (forging != null) {
            int xOffset;
            int i;
            int progress = forging.getWork();
            this.m_93228_(poseStack, guiLeft + 13 + progress, guiTop + 100, 176, 0, 5, 5);
            int target = forging.getWorkTarget();
            this.m_93228_(poseStack, guiLeft + 13 + target, guiTop + 94, 181, 0, 5, 5);
            ForgeSteps steps = forging.getSteps();
            AnvilRecipe recipe = forging.getRecipe(level);
            if (recipe != null) {
                ForgeRule[] rules = recipe.getRules();
                for (i = 0; i < rules.length; ++i) {
                    ForgeRule rule = rules[i];
                    if (rule == null) continue;
                    xOffset = i * 19;
                    AnvilScreen.m_93160_((PoseStack)poseStack, (int)(guiLeft + 64 + xOffset), (int)(guiTop + 10), (int)10, (int)10, (float)rule.iconX(), (float)rule.iconY(), (int)32, (int)32, (int)256, (int)256);
                    if (rule.matches(steps)) {
                        RenderSystem.m_157429_((float)0.0f, (float)0.6f, (float)0.2f, (float)1.0f);
                    } else {
                        RenderSystem.m_157429_((float)1.0f, (float)0.4f, (float)0.0f, (float)1.0f);
                    }
                    this.m_93228_(poseStack, guiLeft + 59 + xOffset, guiTop + 7, 198, rule.overlayY(), 20, 22);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            ForgeStep[] stepSequence = new ForgeStep[]{steps.last(), steps.secondLast(), steps.thirdLast()};
            for (i = 0; i < 3; ++i) {
                ForgeStep step = stepSequence[i];
                if (step == null) continue;
                xOffset = i * 19;
                AnvilScreen.m_93160_((PoseStack)poseStack, (int)(guiLeft + 64 + xOffset), (int)(guiTop + 31), (int)10, (int)10, (float)step.iconX(), (float)step.iconY(), (int)32, (int)32, (int)256, (int)256);
            }
        }
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        AnvilRecipe recipe;
        super.m_7025_(poseStack, mouseX, mouseY);
        for (Widget widget : this.f_169369_) {
            Button button;
            if (!(widget instanceof Button) || !(button = (Button)widget).m_198029_()) continue;
            button.m_7428_(poseStack, mouseX, mouseY);
            return;
        }
        Level level = ((AnvilBlockEntity)this.blockEntity).m_58904_();
        Forging forging = ((AnvilBlockEntity)this.blockEntity).getMainInputForging();
        if (forging != null && level != null && (recipe = forging.getRecipe(level)) != null) {
            ForgeRule[] rules = recipe.getRules();
            for (int i = 0; i < rules.length; ++i) {
                ForgeRule rule = rules[i];
                if (rule == null) continue;
                int xOffset = i * 19;
                int x = this.getGuiLeft() + 64 + xOffset;
                int y = this.getGuiTop() + 10;
                if (mouseX <= x || mouseX >= x + 10 || mouseY <= y || mouseY >= y + 10) continue;
                this.m_96602_(poseStack, rule.getDescriptionId(), mouseX, mouseY);
            }
        }
    }
}

