/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.tank;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.BoilerData;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidTankBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected FluidTank tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    protected boolean window = true;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    public BoilerData boiler;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;

    public FluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.boiler = new BoilerData();
        this.refreshCapability();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(FluidTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.isController()) {
            this.boiler.tick(this);
        }
    }

    @Override
    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        FluidAttributes attributes = newFluidStack.getFluid().getAttributes();
        int luminosity = (int)((float)attributes.getLuminosity(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_142082_(xOffset, yOffset, zOffset);
                    FluidTankBlockEntity tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt(this.m_58903_(), (BlockGetter)this.f_58857_, pos);
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
            }
            this.fluidLevel.chase(this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public FluidTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * FluidTankBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    @Override
    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.boiler.clear();
        this.onFluidStackChanged(this.tankInventory.getFluid());
        BlockState state = this.m_58900_();
        if (FluidTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_(FluidTankBlock.SHAPE, (Comparable)((Object)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN)));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void toggleWindows() {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (be.boiler.isActive()) {
            return;
        }
        be.setWindows(!be.window);
    }

    public void updateBoilerTemperature() {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (!be.boiler.isActive()) {
            return;
        }
        be.boiler.needsHeatLevelUpdate = true;
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    @Override
    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_142082_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                    }
                    this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(FluidTankBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.f_58857_.m_7726_().m_7827_().m_142202_(pos);
                }
            }
        }
    }

    public void updateBoilerState() {
        if (!this.isController()) {
            return;
        }
        boolean wasBoiler = this.boiler.isActive();
        boolean changed = this.boiler.evaluate(this);
        if (wasBoiler != this.boiler.isActive()) {
            if (this.boiler.isActive()) {
                this.setWindows(false);
            }
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_142082_(xOffset, yOffset, zOffset));
                        if (!(blockEntity instanceof FluidTankBlockEntity)) continue;
                        FluidTankBlockEntity fbe = (FluidTankBlockEntity)blockEntity;
                        fbe.refreshCapability();
                    }
                }
            }
        }
        if (changed) {
            this.notifyUpdate();
            this.boiler.checkPipeOrganAdvancement(this);
        }
    }

    @Override
    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(this::handlerForCapability);
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? (this.boiler.isActive() ? this.boiler.createHandler() : this.tankInventory) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    @Override
    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    @Override
    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public FluidTankBlockEntity getOtherFluidTankBlockEntity(Direction direction) {
        BlockEntity otherBE = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
        if (otherBE instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)otherBE;
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        FluidTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        if (controllerBE.boiler.addToGoggleTooltip(tooltip, isPlayerSneaking, controllerBE.getTotalTankSize())) {
            return true;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.window = compound.m_128471_("Window");
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * FluidTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.boiler.read(compound.m_128469_("Boiler"), this.width * this.width * this.height);
        if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FluidTankBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(fillState);
            }
            this.fluidLevel.chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.m_58898_()) {
            this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
        }
        if (compound.m_128441_("LazySync")) {
            this.fluidLevel.chase(this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        compound.m_128365_("Boiler", (Tag)this.boiler.write());
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128379_("Window", this.window);
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        compound.m_128405_("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.m_128379_("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN);
    }

    public IFluidTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (FluidTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.updateBoilerState();
        this.m_6596_();
    }

    @Override
    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Override
    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    @Override
    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    @Override
    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    @Override
    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return FluidTankBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public boolean hasTank() {
        return true;
    }

    @Override
    public int getTankSize(int tank) {
        return FluidTankBlockEntity.getCapacityMultiplier();
    }

    @Override
    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    @Override
    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    @Override
    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }
}

