/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.DivingHelmetItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class NetheriteDivingHandler {
    public static final String NETHERITE_DIVING_BITS_KEY = "CreateNetheriteDivingBits";
    public static final String FIRE_IMMUNE_KEY = "CreateFireImmune";

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        EquipmentSlot slot = event.getSlot();
        if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack to = event.getTo();
        if (slot == EquipmentSlot.HEAD) {
            if (NetheriteDivingHandler.isNetheriteDivingHelmet(to)) {
                NetheriteDivingHandler.setBit(entity, slot);
            } else {
                NetheriteDivingHandler.clearBit(entity, slot);
            }
        } else if (slot == EquipmentSlot.CHEST) {
            if (NetheriteDivingHandler.isNetheriteBacktank(to) && BacktankUtil.hasAirRemaining(to)) {
                NetheriteDivingHandler.setBit(entity, slot);
            } else {
                NetheriteDivingHandler.clearBit(entity, slot);
            }
        } else if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) {
            if (NetheriteDivingHandler.isNetheriteArmor(to)) {
                NetheriteDivingHandler.setBit(entity, slot);
            } else {
                NetheriteDivingHandler.clearBit(entity, slot);
            }
        }
    }

    public static boolean isNetheriteDivingHelmet(ItemStack stack) {
        return stack.m_41720_() instanceof DivingHelmetItem && NetheriteDivingHandler.isNetheriteArmor(stack);
    }

    public static boolean isNetheriteBacktank(ItemStack stack) {
        return stack.m_204117_(AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.tag) && NetheriteDivingHandler.isNetheriteArmor(stack);
    }

    public static boolean isNetheriteArmor(ItemStack stack) {
        ArmorItem armorItem;
        Item item = stack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_41475_();
    }

    public static void setBit(LivingEntity entity, EquipmentSlot slot) {
        CompoundTag nbt = entity.getPersistentData();
        byte bits = nbt.m_128445_(NETHERITE_DIVING_BITS_KEY);
        if ((bits & 0xF) == 15) {
            return;
        }
        bits = (byte)(bits | 1 << slot.m_20749_());
        nbt.m_128344_(NETHERITE_DIVING_BITS_KEY, bits);
        if ((bits & 0xF) == 15) {
            NetheriteDivingHandler.setFireImmune(entity, true);
        }
    }

    public static void clearBit(LivingEntity entity, EquipmentSlot slot) {
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(NETHERITE_DIVING_BITS_KEY)) {
            return;
        }
        byte bits = nbt.m_128445_(NETHERITE_DIVING_BITS_KEY);
        boolean prevFullSet = (bits & 0xF) == 15;
        bits = (byte)(bits & ~(1 << slot.m_20749_()));
        nbt.m_128344_(NETHERITE_DIVING_BITS_KEY, bits);
        if (prevFullSet) {
            NetheriteDivingHandler.setFireImmune(entity, false);
        }
    }

    public static void setFireImmune(LivingEntity entity, boolean fireImmune) {
        entity.getPersistentData().m_128379_(FIRE_IMMUNE_KEY, fireImmune);
    }
}

