/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.framedblocks;

import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FramedBlocksInSchematics {
    static final List<String> KEYS_TO_RETAIN = List.of("intangible", "glowing", "reinforced", "camo_stack", "camo_stack_two", "camo_state", "camo_state_two");

    public static CompoundTag prepareBlockEntityData(BlockState blockState, BlockEntity blockEntity) {
        CompoundTag data = null;
        if (blockEntity == null) {
            return data;
        }
        data = blockEntity.m_187480_();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : data.m_128431_()) {
            if (KEYS_TO_RETAIN.contains(key)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            data.m_128473_(key);
        }
        return data;
    }

    public static ItemRequirement getRequiredItems(BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity == null) {
            return ItemRequirement.NONE;
        }
        CompoundTag data = blockEntity.m_187480_();
        ArrayList<ItemRequirement.StackRequirement> list = new ArrayList<ItemRequirement.StackRequirement>();
        if (data.m_128471_("intangible")) {
            list.add(new ItemRequirement.StackRequirement(new ItemStack((ItemLike)Items.f_42714_), ItemRequirement.ItemUseType.CONSUME));
        }
        if (data.m_128471_("glowing")) {
            list.add(new ItemRequirement.StackRequirement(new ItemStack((ItemLike)Items.f_42525_), ItemRequirement.ItemUseType.CONSUME));
        }
        if (data.m_128471_("reinforced")) {
            list.add(new ItemRequirement.StackRequirement(new ItemStack((ItemLike)Mods.FRAMEDBLOCKS.getItem("framed_reinforcement")), ItemRequirement.ItemUseType.CONSUME));
        }
        if (data.m_128441_("camo_stack")) {
            FramedBlocksInSchematics.addCamoStack(data.m_128469_("camo_stack"), list);
        }
        if (data.m_128441_("camo_stack_two")) {
            FramedBlocksInSchematics.addCamoStack(data.m_128469_("camo_stack_two"), list);
        }
        return new ItemRequirement(list);
    }

    private static void addCamoStack(CompoundTag tag, List<ItemRequirement.StackRequirement> list) {
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)tag);
        if (!itemStack.m_41619_()) {
            list.add(new ItemRequirement.StackRequirement(itemStack, ItemRequirement.ItemUseType.CONSUME));
        }
    }
}

