/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine.caps;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.item.MultiTrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineItemHandler;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class AssemblyLineMultiItemHandler<T extends BlockEntityMultiMachine<T>>
extends MultiMachineItemHandler<T> {
    List<ITrackedHandler> inputList = new ArrayList<ITrackedHandler>();

    public AssemblyLineMultiItemHandler(T tile) {
        super(tile);
    }

    public List<ItemStack> consumeInputs(IRecipe recipe, boolean simulate) {
        if (recipe.getInputItems().size() > this.inputList.size()) {
            return Collections.emptyList();
        }
        boolean chance = !simulate && recipe.hasInputChances();
        int[] chances = recipe.getInputChances();
        ArrayList<ItemStack> consumed = new ArrayList<ItemStack>();
        for (int i = 0; i < recipe.getInputItems().size(); ++i) {
            if (!chance || Ref.RNG.nextInt(10000) < chances[i]) {
                consumed.addAll(this.consumeInput((Ingredient)recipe.getInputItems().get(i), this.inputList.get(i), !chance && simulate));
                continue;
            }
            consumed.add(Data.DEBUG_SCANNER.get(1));
        }
        return consumed;
    }

    public List<ItemStack> consumeInput(Ingredient input, ITrackedHandler container, boolean simulate) {
        boolean success;
        if (input == null) {
            return Collections.emptyList();
        }
        IntOpenHashSet skipSlots = new IntOpenHashSet(this.getInputHandler().getSlots());
        ObjectArrayList consumedItems = new ObjectArrayList();
        int failed = 0;
        int countToReach = RecipeIngredient.count((Ingredient)input);
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack item = container.getStackInSlot(i);
            if (input.test(item) && !skipSlots.contains(i)) {
                int toConsume = Math.min(item.m_41613_(), Math.max(countToReach - item.m_41613_(), countToReach));
                countToReach -= toConsume;
                skipSlots.add(i);
                ItemStack copy = item.m_41777_();
                copy.m_41764_(toConsume);
                consumedItems.add(copy);
                if (!RecipeIngredient.ignoreConsume((Ingredient)input) && !simulate) {
                    container.extractFromInput(i, toConsume, simulate);
                }
                if (countToReach == 0) break;
            }
            if (i != container.getSlots() - 1) continue;
            ++failed;
        }
        boolean bl = success = failed == 0;
        if (!simulate && success) {
            ((BlockEntityMultiMachine)this.tile).m_6596_();
        }
        if (simulate) {
            return success ? consumedItems : Collections.emptyList();
        }
        return consumedItems;
    }

    public void invalidate() {
        super.invalidate();
        this.inputList.clear();
    }

    protected ITrackedHandler calculateInputs() {
        this.inputList = ((BlockEntityMultiMachine)this.tile).getComponentsByHandlerId(this.inputComponentString()).stream().filter(t -> t.getItemHandler().isPresent()).map(t -> (MachineItemHandler)t.getItemHandler().get()).sorted((x$0, x$1) -> this.compareInputBuses((MachineItemHandler)x$0, (MachineItemHandler)x$1)).map(MachineItemHandler::getInputHandler).collect(Collectors.toList());
        return new MultiTrackedItemHandler(this.inputList.toArray(new IItemHandlerModifiable[0]));
    }
}

