/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.multi;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.material.FluidProduct;
import org.gtreimagined.gtcore.data.GTCoreFluids;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;

public class DistillationTowerLoader {
    public static void init() {
        if (GT5RConfig.COMPLICATED_CHEMICAL_PROCESSING.get()) {
            DistillationTowerLoader.initComplicated();
        }
        DistillationTowerLoader.initBasic();
        DistillationTowerLoader.initCracked();
        DistillationTowerLoader.addDistillingRecipe(Materials.Creosote, 24, 16, 96, ItemStack.f_41583_, new FluidProduct(Materials.Lubricant, 12));
        DistillationTowerLoader.addDistillingRecipe(Materials.FishOil, 24, 16, 96, ItemStack.f_41583_, new FluidProduct(Materials.Lubricant, 12));
        DistillationTowerLoader.addDistillingRecipe(Materials.SeedOil, 32, 16, 96, ItemStack.f_41583_, new FluidProduct(Materials.Lubricant, 12));
        DistillationTowerLoader.addDistillingRecipe(Materials.Water, 100, 16, 64, GTMaterialTypes.TINY_DUST.get(Materials.Calcite, 1), new FluidProduct(Materials.DistilledWater, 80));
        RecipeMaps.DISTILLERY.RB().ii(new Ingredient[]{((RecipeIngredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)0)).setNoConsume()}).fi(new FluidStack[]{new FluidStack((Fluid)GTCoreFluids.BEET_JUICE.getFluid(), 100)}).fo(new FluidStack[]{Materials.DistilledWater.getLiquid(50)}).io(new Item[]{Items.f_42501_}).add("beet_juice", 80L, 16L);
        RecipeMaps.DISTILLERY.RB().ii(new Ingredient[]{((RecipeIngredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)0)).setNoConsume()}).fi(new FluidStack[]{Materials.Honey.getLiquid(100)}).fo(new FluidStack[]{Materials.DistilledWater.getLiquid(10)}).io(new Item[]{Items.f_42501_}).add("honey", 16L, 16L);
        DistillationTowerLoader.addDistillingRecipe(Materials.DilutedHydrochloricAcid, 2000, 300, 64, ItemStack.f_41583_, new FluidProduct(Materials.HydrochloricAcid, 1000), new FluidProduct(Materials.Water, 1000));
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.Biomass, 80, 16, 64, 24, 16, GTMaterialTypes.SMALL_DUST.get(Materials.Wood, 1), new FluidProduct(Materials.Ethanol, 20), new FluidProduct(Materials.Glycerol, 20), new FluidProduct(Materials.Methane, 4), new FluidProduct(Materials.DistilledWater, 50));
        DistillationTowerLoader.addDistillationRecipe(Materials.WoodGas, 1000, 40, 256, ItemStack.f_41583_, new FluidProduct(Materials.CarbonDioxide, 490), new FluidProduct(Materials.Ethylene, 20), new FluidProduct(Materials.Methane, 130), new FluidProduct(Materials.CarbonMonoxide, 340), new FluidProduct(Materials.Hydrogen, 20));
        DistillationTowerLoader.addDistillingRecipe(Materials.WoodGas, 100, 16, 64, ItemStack.f_41583_, new FluidProduct(Materials.Ethylene, 4));
        Material ethane = GT5RConfig.COMPLICATED_CHEMICAL_PROCESSING.get() ? Materials.Ethane : Materials.Ethylene;
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.RefineryGas, 1000, 240, 120, new FluidProduct(Materials.Butane, 60), new FluidProduct(Materials.Propane, 70), new FluidProduct(ethane, 100), new FluidProduct(Materials.Methane, 750), new FluidProduct(Materials.Helium, 20));
        RecipeMaps.CRYO_DISTILLATION.RB().fi(new FluidStack[]{Materials.Air.getGas(200)}).fo(new FluidStack[]{Materials.Helium.getGas(1), Materials.Neon.getGas(1), Materials.Argon.getGas(1), Materials.Nitrogen.getGas(143), Materials.Oxygen.getGas(50), Materials.CarbonDioxide.getGas(10)}).add("air_distillation", 64L, 64L);
        RecipeMaps.CRYO_DISTILLATION.RB().fi(new FluidStack[]{Materials.EnderAir.getGas(200)}).fo(new FluidStack[]{Materials.Krypton.getGas(1), Materials.Xenon.getGas(1), Materials.Radon.getGas(1), Materials.Nitrogen.getGas(143), Materials.Oxygen.getGas(50), Materials.CarbonDioxide.getGas(10)}).add("ender_air_distillation", 64L, 64L);
        RecipeMaps.CRYO_DISTILLATION.RB().fi(new FluidStack[]{Materials.NetherAir.getGas(200)}).fo(new FluidStack[]{Materials.Helium.getGas(1), Materials.Neon.getGas(1), Materials.Argon.getGas(1), Materials.Nitrogen.getGas(143), Materials.Oxygen.getGas(50), Materials.SulfurDioxide.getGas(10)}).add("nether_air_distillation", 64L, 64L);
    }

    private static void initCracked() {
        DistillationTowerLoader.addDistillationRecipe(Materials.SteamCrackedButane, 1000, 120, 120, GTMaterialTypes.SMALL_DUST.get(Materials.Carbon, 1), new FluidProduct(Materials.Butadiene, 500), new FluidProduct(Materials.Propene, 1000), new FluidProduct(Materials.Ethylene, 1000), new FluidProduct(Materials.Methane, 500));
        DistillationTowerLoader.addDistillationRecipe(Materials.SteamCrackedNaphtha, 1000, 120, 120, GTMaterialTypes.SMALL_DUST.get(Materials.Carbon, 1), new FluidProduct(Materials.Toluene, 200), new FluidProduct(Materials.Benzene, 400), new FluidProduct(Materials.Butadiene, 400), new FluidProduct(Materials.Propene, 600), new FluidProduct(Materials.Ethylene, 600), new FluidProduct(Materials.Methane, 600));
        DistillationTowerLoader.addDistillationRecipe(Materials.SteamCrackedEthane, 1000, 120, 120, GTMaterialTypes.SMALL_DUST.get(Materials.Carbon, 1), new FluidProduct(Materials.Ethylene, 1000), new FluidProduct(Materials.Methane, 500));
        DistillationTowerLoader.addDistillationRecipe(Materials.SteamCrackedPropane, 1000, 120, 120, GTMaterialTypes.SMALL_DUST.get(Materials.Carbon, 1), new FluidProduct(Materials.Propene, 500), new FluidProduct(Materials.Ethylene, 1000), new FluidProduct(Materials.Methane, 500));
        DistillationTowerLoader.addDistillationRecipe(Materials.HydroCrackedEthane, 1000, 120, 120, new FluidProduct(Materials.Methane, 2000));
        DistillationTowerLoader.addDistillationRecipe(Materials.HydroCrackedRefineryGas, 1000, 120, 120, new FluidProduct(Materials.Methane, 1500), new FluidProduct(Materials.Helium, 20));
        DistillationTowerLoader.addDistillationRecipe(Materials.HydroCrackedPropane, 1000, 120, 120, new FluidProduct(Materials.Ethane, 1000), new FluidProduct(Materials.Methane, 1000));
        DistillationTowerLoader.addDistillationRecipe(Materials.HydroCrackedButane, 1000, 120, 120, new FluidProduct(Materials.Propane, 1000), new FluidProduct(Materials.Ethane, 1000), new FluidProduct(Materials.Methane, 1000));
        DistillationTowerLoader.addDistillationRecipe(Materials.HydroCrackedNaphtha, 1000, 120, 120, new FluidProduct(Materials.Butane, 750), new FluidProduct(Materials.Propane, 750), new FluidProduct(Materials.Ethane, 750), new FluidProduct(Materials.Methane, 750));
    }

    private static void initBasic() {
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.OilLight, 25, 64, 64, new FluidProduct(Materials.FuelOil, 15), new FluidProduct(Materials.Diesel, 10), new FluidProduct(Materials.Naphtha, 10), new FluidProduct(Materials.Kerosene, 10), new FluidProduct(Materials.RefineryGas, 25), new FluidProduct(Materials.Lubricant, 15), new FluidProduct(Materials.Tar, 15));
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.Oil, 25, 64, 64, new FluidProduct(Materials.FuelOil, 25), new FluidProduct(Materials.Diesel, 15), new FluidProduct(Materials.Naphtha, 15), new FluidProduct(Materials.Kerosene, 15), new FluidProduct(Materials.RefineryGas, 15), new FluidProduct(Materials.Lubricant, 25), new FluidProduct(Materials.Tar, 15));
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.OilHeavy, 25, 64, 64, new FluidProduct(Materials.FuelOil, 30), new FluidProduct(Materials.Diesel, 20), new FluidProduct(Materials.Naphtha, 20), new FluidProduct(Materials.Kerosene, 20), new FluidProduct(Materials.RefineryGas, 10), new FluidProduct(Materials.Lubricant, 40), new FluidProduct(Materials.Tar, 15));
    }

    private static void initComplicated() {
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.CharcoalByproducts, 1000, 40, 256, 64, 80, GTMaterialTypes.SMALL_DUST.get(Materials.Charcoal, 1), new FluidProduct(Materials.WoodTar, 250), new FluidProduct(Materials.WoodVinegar, 500), new FluidProduct(Materials.WoodGas, 250));
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.FermentedBiomass, 1000, 75, 180, 8, 1500, ItemStack.f_41583_, new FluidProduct(Materials.AceticAcid, 25), new FluidProduct(Materials.Water, 375), new FluidProduct(Materials.Ethanol, 150), new FluidProduct(Materials.Methanol, 150), new FluidProduct(Materials.Ammonia, 100), new FluidProduct(Materials.CarbonDioxide, 400), new FluidProduct(Materials.Methane, 600));
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.WoodVinegar, 1000, 40, 256, new FluidProduct(Materials.AceticAcid, 100), new FluidProduct(Materials.Water, 500), new FluidProduct(Materials.Ethanol, 10), new FluidProduct(Materials.Methanol, 300), new FluidProduct(Materials.Acetone, 50), new FluidProduct(Materials.MethylAcetate, 10));
        DistillationTowerLoader.addDistillationDistillingRecipe(Materials.WoodTar, 1000, 40, 256, new FluidProduct(Materials.Creosote, 500), new FluidProduct(Materials.Phenol, 75), new FluidProduct(Materials.Benzene, 350), new FluidProduct(Materials.Toluene, 75));
    }

    private static void addDistillationDistillingRecipe(Material input, int amount, int ticks, int euPerTick, int distilleryPerTick, int distilleryTicks, ItemStack itemStack, FluidProduct ... outputs) {
        DistillationTowerLoader.addDistillationRecipe(input, amount, ticks, euPerTick, itemStack, outputs);
        for (int i = 0; i < outputs.length; ++i) {
            RecipeBuilder b = RecipeMaps.DISTILLERY.RB().ii(new Ingredient[]{((RecipeIngredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)(i + 1))).setNoConsume()}).fi(new FluidStack[]{input.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) ? input.getLiquid(amount) : input.getGas(amount)}).fo(new FluidStack[]{outputs[i].convert()});
            if (!itemStack.m_41619_()) {
                b.io(new ItemStack[]{itemStack});
            }
            b.add(input.getId() + "_" + outputs[i].mat().getId(), (long)distilleryTicks, (long)distilleryPerTick);
        }
    }

    private static void addDistillationDistillingRecipe(Material input, int amount, int ticks, int euPerTick, FluidProduct ... outputs) {
        DistillationTowerLoader.addDistillationDistillingRecipe(input, amount, ticks, euPerTick, euPerTick / 4, ticks, ItemStack.f_41583_, outputs);
    }

    private static void addDistillingRecipe(Material input, int amount, int ticks, int euPerTick, ItemStack itemStack, FluidProduct ... outputs) {
        for (int i = 0; i < outputs.length; ++i) {
            RecipeBuilder b = RecipeMaps.DISTILLERY.RB().ii(new Ingredient[]{((RecipeIngredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)(i + 1))).setNoConsume()}).fi(new FluidStack[]{input.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) ? input.getLiquid(amount) : input.getGas(amount)}).fo(new FluidStack[]{outputs[i].convert()});
            if (!itemStack.m_41619_()) {
                b.io(new ItemStack[]{itemStack});
            }
            b.add(input.getId() + "_" + outputs[i].mat().getId(), (long)ticks, (long)euPerTick);
        }
    }

    private static void addDistillationRecipe(Material input, int amount, int ticks, int euPerTick, ItemStack itemOutput, FluidProduct ... outputs) {
        RecipeBuilder builder = RecipeMaps.DISTILLATION.RB().fi(new FluidStack[]{input.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) ? input.getLiquid(amount) : input.getGas(amount)});
        for (int i = 0; i < outputs.length; ++i) {
            Material fo = outputs[i].mat();
            if (fo.has(new IMaterialTag[]{GTMaterialTypes.LIQUID})) {
                builder.fo(new FluidStack[]{outputs[i].mat().getLiquid(outputs[i].amount())});
                continue;
            }
            if (!fo.has(new IMaterialTag[]{GTMaterialTypes.GAS})) continue;
            builder.fo(new FluidStack[]{outputs[i].mat().getGas(outputs[i].amount())});
        }
        if (!itemOutput.m_41619_()) {
            builder.io(new ItemStack[]{itemOutput});
        }
        builder.add(input.getId(), (long)ticks, (long)euPerTick);
    }

    private static void addDistillationRecipe(Material input, int amount, int ticks, int euPerTick, FluidProduct ... outputs) {
        DistillationTowerLoader.addDistillationRecipe(input, amount, ticks, euPerTick, ItemStack.f_41583_, outputs);
    }
}

