/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.items;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityNuclearReactorCore;
import org.gtreimagined.gt5r.items.IItemReactorRod;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.IMaterialObject;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemEnrichedRod
extends ItemBasic<ItemEnrichedRod>
implements IItemReactorRod,
IMaterialObject {
    private final Material material;
    private final Supplier<Item> breederRod;

    public ItemEnrichedRod(String domain, Material material, Supplier<Item> breederRod) {
        super(domain, material.getId() + "_enriched_rod", new Item.Properties().m_41487_(16).m_41491_(Ref.TAB_ITEMS));
        this.material = material;
        this.breederRod = breederRod;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.enriched_rod.0", (Object[])new Object[0]).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.depleted_rod.1", (Object[])new Object[0]).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.enriched_rod.1", (Object[])new Object[]{this.breederRod.get().m_7968_().m_41786_()}).m_130940_(ChatFormatting.GREEN));
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture("gt5r", "item/basic/nuclear_fuel_rod"), new Texture("gt5r", "item/basic/empty_nuclear_fuel_rod")};
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (i == 0 && this.material != Material.NULL) {
            return this.material.getRGB();
        }
        return IItemReactorRod.super.getItemColor(stack, block, i);
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public boolean isReactorRod(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isModerated(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return false;
    }

    @Override
    public void updateModeration(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
    }

    @Override
    public int getReactorRodNeutronEmission(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return 0;
    }

    @Override
    public boolean getReactorRodNeutronReaction(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        reactor.heatHandler.ifPresent(h -> h.insertInternal(reactor.oNeutronCounts[slot] / 2, false));
        return true;
    }

    @Override
    public int getReactorRodNeutronReflection(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack, int neutrons, boolean moderated) {
        int n = slot;
        reactor.mNeutronCounts[n] = reactor.mNeutronCounts[n] + neutrons;
        return 0;
    }

    @Override
    public int getReactorRodNeutronMaximum(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return 0;
    }
}

