/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.fluids.FlowingFluidRegistryObject;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.tfc.data.TFCToolTypes;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.AlloyingFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.HeatingFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.QuernFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.RockKnappingFinishedRecipe;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.MaterialTags;

public class TFCRecipes {
    public static void initRecipes(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        consumer.accept(new QuernFinishedRecipe(new ResourceLocation("gt5r", "quern/raw_redstone"), Ingredient.m_204132_((TagKey)GTMaterialTypes.RAW_ORE.getMaterialTag(Materials.Redstone)), new ItemStack((ItemLike)Items.f_42451_, 8)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_axe_head"), new String[]{" X   ", "XXXX ", "XXXXX", "XXXX ", " X   "}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.AXE_HEAD.get(Materials.Flint, 1)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_hoe_head_1"), new String[]{"XXXXX", "XX   ", "     ", "XXXXX", "XX   "}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.HOE_HEAD.get(Materials.Flint, 2)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_hoe_head_2"), new String[]{"XXXXX", "XX   ", "     ", "XXXXX", "   XX"}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.HOE_HEAD.get(Materials.Flint, 2)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_hoe_head"), new String[]{"XXXXX", "   XX"}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.HOE_HEAD.get(Materials.Flint, 1)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_knife_head_1"), new String[]{"X  X ", "XX XX", "XX XX", "XX XX", "XX XX"}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.KNIFE_HEAD.get(Materials.Flint, 2)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_knife_head_2"), new String[]{"X   X", "XX XX", "XX XX", "XX XX", "XX XX"}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.KNIFE_HEAD.get(Materials.Flint, 2)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_knife_head_3"), new String[]{" X X ", "XX XX", "XX XX", "XX XX", "XX XX"}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.KNIFE_HEAD.get(Materials.Flint, 2)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_knife_head"), new String[]{"X ", "XX", "XX", "XX", "XX"}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.KNIFE_HEAD.get(Materials.Flint, 1)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_shovel_head"), new String[]{"XXX", "XXX", "XXX", "XXX", " X "}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), GTMaterialTypes.SHOVEL_HEAD.get(Materials.Flint, 1)));
        consumer.accept(new RockKnappingFinishedRecipe(new ResourceLocation("gt5r", "rock_knapping/flint_javelin_head"), new String[]{"XXX  ", "XXXX ", "XXXXX", " XXX ", "  X  "}, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), TFCToolTypes.JAVELIN_HEAD.get(Materials.Flint, 1)));
        MaterialTags.TOOLS.getAll().forEach((m, t) -> {
            TagKey rod;
            if (t.toolTypes().contains(TFCToolTypes.JAVELIN)) {
                rod = t.handleMaterial().has(new IMaterialTag[]{GTMaterialTypes.ROD}) ? GTMaterialTypes.ROD.getMaterialTag(t.handleMaterial()) : GTMaterialTypes.ROD.getMaterialTag(GTLibMaterials.Wood);
                provider.addStackRecipe(consumer, "gt5r", m.getId() + "_javelin_from_javelin_head", "gt_tools_from_tool_parts", TFCToolTypes.JAVELIN.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('T'), (Object)TFCToolTypes.JAVELIN_HEAD.getMaterialTag(m), (Object)Character.valueOf('R'), (Object)rod), new String[]{"T", "R"});
            }
            if (t.toolTypes().contains(GTTools.KNIFE)) {
                rod = t.handleMaterial().has(new IMaterialTag[]{GTMaterialTypes.ROD}) ? GTMaterialTypes.ROD.getMaterialTag(t.handleMaterial()) : GTMaterialTypes.ROD.getMaterialTag(GTLibMaterials.Wood);
                provider.addStackRecipe(consumer, "gt5r", m.getId() + "_knife_from_knife_head", "gt_tools_from_tool_parts", GTTools.KNIFE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GTMaterialTypes.KNIFE_HEAD.getMaterialTag(m), (Object)Character.valueOf('R'), (Object)rod), new String[]{"T", "R"});
            }
        });
        for (Ore ore : Ore.values()) {
            if (!ore.isGraded()) continue;
            TFCMetal tfcMetal = TFCRecipes.metalFromOre(ore);
            FlowingFluid fluid = ((FlowingFluidRegistryObject)TFCFluids.METALS.get(tfcMetal.metal)).getSource();
            for (Ore.Grade grade : Ore.Grade.values()) {
                consumer.accept(new HeatingFinishedRecipe(new ResourceLocation("tfc", "heating/ore/" + grade.name().toLowerCase() + "_" + ore.name().toLowerCase()), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)((RegistryObject)((Map)TFCItems.GRADED_ORES.get(ore)).get(grade)).get()}), new FluidStack((Fluid)fluid, grade == Ore.Grade.POOR ? 25 : (grade == Ore.Grade.NORMAL ? 50 : 100)), tfcMetal.temperature));
            }
        }
        consumer.accept(new AlloyingFinishedRecipe(new ResourceLocation("tfc", "alloy/sterling_silver"), "tfc:sterling_silver", new AlloyingFinishedRecipe.Alloy("tfc:copper", 0.2, 0.25), new AlloyingFinishedRecipe.Alloy("tfc:silver", 0.75, 0.8)));
        consumer.accept(new AlloyingFinishedRecipe(new ResourceLocation("tfc", "alloy/rose_gold"), "tfc:rose_gold", new AlloyingFinishedRecipe.Alloy("tfc:copper", 0.2, 0.25), new AlloyingFinishedRecipe.Alloy("tfc:gold", 0.75, 0.8)));
        consumer.accept(new AlloyingFinishedRecipe(new ResourceLocation("tfc", "alloy/bismuth_bronze"), "tfc:bismuth_bronze", new AlloyingFinishedRecipe.Alloy("tfc:zinc", 0.25, 0.3), new AlloyingFinishedRecipe.Alloy("tfc:copper", 0.5, 0.6), new AlloyingFinishedRecipe.Alloy("tfc:bismuth", 0.15, 0.2)));
        consumer.accept(new AlloyingFinishedRecipe(new ResourceLocation("tfc", "alloy/black_bronze"), "tfc:black_bronze", new AlloyingFinishedRecipe.Alloy("tfc:copper", 0.6, 0.7), new AlloyingFinishedRecipe.Alloy("tfc:gold", 0.15, 0.2), new AlloyingFinishedRecipe.Alloy("tfc:silver", 0.15, 0.2)));
    }

    private static TFCMetal metalFromOre(Ore ore) {
        return switch (ore) {
            case Ore.BISMUTHINITE -> TFCMetal.BISMUTH;
            case Ore.HEMATITE, Ore.LIMONITE, Ore.MAGNETITE -> TFCMetal.CAST_IRON;
            case Ore.NATIVE_COPPER, Ore.MALACHITE, Ore.TETRAHEDRITE -> TFCMetal.COPPER;
            case Ore.GARNIERITE -> TFCMetal.NICKEL;
            case Ore.SPHALERITE -> TFCMetal.ZINC;
            case Ore.CASSITERITE -> TFCMetal.TIN;
            case Ore.NATIVE_GOLD -> TFCMetal.GOLD;
            case Ore.NATIVE_SILVER -> TFCMetal.SILVER;
            default -> TFCMetal.UNKNOWN;
        };
    }

    private static enum TFCMetal {
        BISMUTH(Metal.Default.BISMUTH, 270),
        CAST_IRON(Metal.Default.CAST_IRON, 1535),
        COPPER(Metal.Default.COPPER, 1080),
        NICKEL(Metal.Default.NICKEL, 1453),
        ZINC(Metal.Default.ZINC, 420),
        TIN(Metal.Default.TIN, 230),
        GOLD(Metal.Default.GOLD, 1060),
        SILVER(Metal.Default.SILVER, 961),
        UNKNOWN(Metal.Default.UNKNOWN, -1);

        private final Metal.Default metal;
        private final int temperature;

        private TFCMetal(Metal.Default metal, int temperature) {
            this.metal = metal;
            this.temperature = temperature;
        }
    }
}

