/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.rei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.integration.rei.OreProcessingDisplay;
import org.gtreimagined.gt5r.integration.xei.OreByProduct;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.integration.rei.REIUtils;
import org.gtreimagined.gtlib.util.Utils;

public class OreProcessingCategory
implements DisplayCategory<OreProcessingDisplay> {
    protected static Renderer icon = EntryStacks.of((ItemLike)Items.f_41834_);
    private static final Component title = Utils.translatable((String)"gt5r.rei.tooltip.ore.byproducts", (Object[])new Object[0]);
    static CategoryIdentifier<? extends OreProcessingDisplay> id = CategoryIdentifier.of((String)"gt5r", (String)"ore_byproducts");

    public CategoryIdentifier<? extends OreProcessingDisplay> getCategoryIdentifier() {
        return id;
    }

    public List<Widget> setupDisplay(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gt5r", "textures/gui/ore_byproducts/background.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gt5r", "textures/gui/ore_byproducts/base.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            if (display.oreByProduct.bathingMode() != OreByProduct.BathingMode.NONE) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gt5r", "textures/gui/ore_byproducts/chem.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (display.oreByProduct.hasSiftingRecipe()) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gt5r", "textures/gui/ore_byproducts/sift.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (display.oreByProduct.hasSepRecipes()) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gt5r", "textures/gui/ore_byproducts/sep.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (display.oreByProduct.hasFurnaceSmeltingRecipe()) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gt5r", "textures/gui/ore_byproducts/smelt.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
        }));
        widgets.addAll(this.setupSlots(display, bounds));
        return widgets;
    }

    private List<Widget> setupSlots(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 4, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)GTMaterialTypes.ORE.getMaterialIngredient(display.oreByProduct.material(), 1))).markInput().disableBackground());
        display.oreByProduct.getSlots().forEach(s -> {
            Slot slot = Widgets.createSlot((Point)this.xy(s.x() + 3, s.y() + 3, bounds));
            if (!s.fluidStacks().isEmpty()) {
                slot.entries((Collection)EntryIngredient.of(s.fluidStacks().stream().map(f -> EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)REIUtils.toREIFLuidStack((FluidStack)f))).toList()));
            }
            if (!s.stacks().isEmpty()) {
                slot.entries((Collection)EntryIngredient.of(s.stacks().stream().map(i -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)i)).toList()));
            }
            if (s.input()) {
                slot.markInput();
            } else {
                slot.markOutput();
            }
            widgets.add((Widget)slot);
        });
        return widgets;
    }

    private Point xy(int x, int y, Rectangle bounds) {
        int offsetX = 0;
        int offsetY = 0;
        return new Point(offsetX + x + bounds.x, offsetY + y + bounds.y);
    }

    private static void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)loc);
        GuiComponent.m_93143_((PoseStack)stack, (int)left, (int)top, (int)0, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)186, (int)166);
    }

    public Component getTitle() {
        return title;
    }

    public Renderer getIcon() {
        return icon;
    }

    public int getDisplayHeight() {
        return 166;
    }

    public int getDisplayWidth(OreProcessingDisplay display) {
        return 186;
    }
}

