/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.gtreimagined.gt5r.gui.ButtonOverlays;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityItemPipe;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturer;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.CodeUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverItemRetriever
extends BaseCover {
    protected boolean whitelist = false;
    protected boolean ignoreNBT = false;

    public CoverItemRetriever(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.getGui().getSlots().add(SlotType.DISPLAY_SETTABLE, 79, 53);
        this.addGuiCallback(t -> {
            t.addSwitchButton(70, 34, 16, 16, ButtonOverlay.WHITELIST, ButtonOverlay.BLACKLIST, h -> !this.whitelist, true, b -> "tooltip.gt5r." + (b != false ? "blacklist" : "whitelist"));
            t.addSwitchButton(88, 34, 16, 16, ButtonOverlays.NBT_OFF, ButtonOverlays.NBT_ON, h -> !this.ignoreNBT, true, b -> "tooltip.gt5r.nbt." + (b != false ? "on" : "off"));
        });
    }

    public void onPlace() {
        super.onPlace();
        if (this.handler.getTile().m_58904_() == null) {
            return;
        }
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityPipe) {
            BlockEntityPipe pipe = (BlockEntityPipe)blockEntity;
            pipe.setConnection(this.side);
        }
    }

    public CompoundTag serializeStack(CompoundTag tag) {
        super.serializeStack(tag);
        tag.m_128379_("whitelist", this.whitelist);
        tag.m_128379_("ignoreNBT", this.ignoreNBT);
        return tag;
    }

    public void deserializeStack(@Nullable CompoundTag tag) {
        super.deserializeStack(tag);
        if (tag == null) {
            return;
        }
        this.whitelist = tag.m_128471_("whitelist");
        this.ignoreNBT = tag.m_128471_("ignoreNBT");
    }

    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        tag.m_128379_("whitelist", this.whitelist);
        tag.m_128379_("ignoreNBT", this.ignoreNBT);
        return tag;
    }

    public void deserialize(CompoundTag nbt) {
        ICoverHandler iCoverHandler;
        super.deserialize(nbt);
        this.whitelist = nbt.m_128471_("whitelist");
        this.ignoreNBT = nbt.m_128471_("ignoreNBT");
        if (this.handler.getTile().m_58904_() != null && this.handler.getTile().m_58904_().m_5776_() && this.factory.getTextures().size() == 2 && (iCoverHandler = this.handler) instanceof CoverHandler) {
            CoverHandler coverHandler = (CoverHandler)iCoverHandler;
            if (coverHandler.coverTexturer != null && coverHandler.coverTexturer.get(this.side) != null) {
                ((DynamicTexturer)coverHandler.coverTexturer.get(this.side)).invalidate();
            }
        }
    }

    public void onUpdate() {
        BlockEntityItemPipe pipe;
        BlockEntity blockEntity;
        if (!this.source().getTile().m_58904_().m_5776_() && (blockEntity = this.source().getTile()) instanceof BlockEntityItemPipe && (pipe = (BlockEntityItemPipe)blockEntity).m_58904_().m_46467_() % 20L == 15L && pipe.pipeCapacityCheck()) {
            ArrayList<BlockEntityItemPipe> tUsedPipes = new ArrayList<BlockEntityItemPipe>();
            Set pipes = CodeUtils.sortByValuesAcending((Map)BlockEntityItemPipe.scanPipes((BlockEntityItemPipe)pipe, new HashMap(), (long)0L, (boolean)true, (boolean)false)).keySet();
            BlockState state = this.handler.getTile().m_58904_().m_8055_(this.handler.getTile().m_58899_().m_142300_(this.side));
            if (state == Blocks.f_50016_.m_49966_()) {
                for (BlockEntityItemPipe p : pipes) {
                    if (!tUsedPipes.add(p)) continue;
                    for (Direction dir : Direction.values()) {
                        IItemHandler itemHandler;
                        BlockEntity a;
                        if (!p.canAcceptItemsFrom(dir, pipe) || dir == this.side && p == pipe || (a = p.getCachedBlockEntity(dir)) instanceof BlockEntityItemPipe || a == null || (itemHandler = (IItemHandler)a.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.m_122424_()).resolve().orElse(null)) == null) continue;
                        Level world = this.handler.getTile().m_58904_();
                        BlockPos pos = this.handler.getTile().m_58899_();
                        ItemStack stack = Utils.extractAny((IItemHandler)itemHandler);
                        if (stack.m_41619_()) continue;
                        double x = (double)(pos.m_123341_() + this.side.m_122429_()) + 0.5;
                        double y = (double)(pos.m_123342_() + this.side.m_122430_()) + 0.5;
                        double z = (double)(pos.m_123343_() + this.side.m_122431_()) + 0.5;
                        ItemEntity entity = new ItemEntity(world, x, y, z, stack, 0.0, 0.0, 0.0);
                        world.m_7967_((Entity)entity);
                        for (BlockEntityItemPipe tUsedPipe : tUsedPipes) {
                            tUsedPipe.incrementTransferCounter(1);
                        }
                        return;
                    }
                }
                return;
            }
            BlockEntity adjacent = pipe.getCachedBlockEntity(this.side);
            if (adjacent == null) {
                return;
            }
            IItemHandler to = adjacent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side.m_122424_()).resolve().orElse(null);
            if (to == null) {
                return;
            }
            for (BlockEntityItemPipe p : pipes) {
                if (!tUsedPipes.add(p)) continue;
                for (Direction dir : Direction.values()) {
                    IItemHandler itemHandler;
                    BlockEntity a;
                    if (!p.canAcceptItemsFrom(dir, pipe) || dir == this.side && p == pipe || (a = p.getCachedBlockEntity(dir)) instanceof BlockEntityItemPipe || a == null || (itemHandler = (IItemHandler)a.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.m_122424_()).resolve().orElse(null)) == null || !Utils.transferItems((IItemHandler)itemHandler, (IItemHandler)to, (boolean)true, s -> this.itemMatches((ItemStack)s, this.getInventory(SlotType.DISPLAY_SETTABLE).getStackInSlot(0)))) continue;
                    for (BlockEntityItemPipe tUsedPipe : tUsedPipes) {
                        tUsedPipe.incrementTransferCounter(1);
                    }
                    return;
                }
            }
        }
    }

    private boolean itemMatches(ItemStack item, ItemStack filter) {
        boolean empty = filter.m_41619_();
        if (empty) {
            return !this.whitelist;
        }
        boolean matches = this.ignoreNBT ? item.m_150930_(filter.m_41720_()) : ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)filter);
        return this.whitelist == matches;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            if (ev.data[1] == 0) {
                this.whitelist = !this.whitelist;
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityBase) {
                    BlockEntityBase base = (BlockEntityBase)blockEntity;
                    base.sidedSync(true);
                }
            } else if (ev.data[1] == 1) {
                this.ignoreNBT = !this.ignoreNBT;
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityBase) {
                    BlockEntityBase base = (BlockEntityBase)blockEntity;
                    base.sidedSync(true);
                }
            }
        }
    }

    public void setTextures(BiConsumer<String, Texture> texer) {
        if (this.factory.getTextures().size() == 2) {
            texer.accept("overlay", (Texture)this.factory.getTextures().get(this.whitelist ? 0 : 1));
        } else {
            super.setTextures(texer);
        }
    }
}

