/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single.miniportals;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.IExtendingBlockEntity;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityMiniPortal
extends BlockEntityMachine<BlockEntityMiniPortal>
implements IExtendingBlockEntity {
    public static List<BlockEntityMiniPortal> sListWorldSide = new ArrayList<BlockEntityMiniPortal>();
    BlockEntityMiniPortal otherSide;
    BlockPos otherSidePos = null;
    ResourceLocation otherSideDimension;
    int invalidatingCaps = 0;

    public BlockEntityMiniPortal(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockEntityMiniPortal getOtherSide() {
        if (this.otherSide != null && this.otherSide.m_58901_()) {
            return null;
        }
        return this.otherSide;
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.isServerSide()) {
            this.addThisPortalToLists();
        }
    }

    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        ServerLevel dimension;
        super.onFirstTickServer(level, pos, state);
        if (this.otherSidePos != null && this.otherSideDimension != null && (dimension = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)this.otherSideDimension))) != null && dimension.m_46749_(this.otherSidePos) && (blockEntity = dimension.m_7702_(this.otherSidePos)) instanceof BlockEntityMiniPortal) {
            BlockEntityMiniPortal portal;
            this.otherSide = portal = (BlockEntityMiniPortal)blockEntity;
            this.otherSideDimension = null;
            this.otherSidePos = null;
        }
    }

    public void invalidateCaps() {
        if (this.invalidatingCaps > 0) {
            return;
        }
        ++this.invalidatingCaps;
        super.invalidateCaps();
        if (this.otherSide != null) {
            this.otherSide.invalidateCaps();
        }
        --this.invalidatingCaps;
    }

    public void invalidateCap(Class<?> cap) {
        if (this.invalidatingCaps > 0) {
            return;
        }
        ++this.invalidatingCaps;
        super.invalidateCap(cap);
        if (this.otherSide != null) {
            this.otherSide.invalidateCap(cap);
        }
        --this.invalidatingCaps;
    }

    public void invalidateCaps(Direction side) {
        if (this.invalidatingCaps > 0) {
            return;
        }
        ++this.invalidatingCaps;
        super.invalidateCaps(side);
        if (this.otherSide != null) {
            this.otherSide.invalidateCaps(side);
        }
        --this.invalidatingCaps;
    }

    protected boolean allowExplosionsInRain() {
        return false;
    }

    public void onBlockUpdate(BlockPos neighbor) {
        super.onBlockUpdate(neighbor);
        Direction facing = Utils.getOffsetFacing((BlockPos)this.m_58899_(), (BlockPos)neighbor);
        if (this.otherSide != null && !this.otherSide.m_58901_()) {
            BlockPos offset = this.otherSide.m_58899_().m_142300_(facing.m_122424_());
            this.otherSide.m_58904_().m_46586_(offset, this.otherSide.m_58904_().m_8055_(offset).m_60734_(), this.otherSide.m_58899_());
        }
    }

    public InteractionResult onInteractBoth(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isPortalSetter(stack) && this.setPortal()) {
            if (!player.m_7500_()) {
                if (stack.m_41763_()) {
                    Utils.damageStack((ItemStack)stack, (InteractionHand)hand, (LivingEntity)player);
                } else {
                    stack.m_41774_(1);
                }
            }
            if (this.otherSide != null) {
                player.m_6352_((Component)Utils.translatable((String)"message.gt5r.mini_portal.connect", (Object[])new Object[]{this.otherSide.m_58899_().m_123341_(), this.otherSide.m_58899_().m_123342_(), this.otherSide.m_58899_().m_123343_(), this.otherSide.m_58904_().m_46472_().m_135782_()}), player.m_142081_());
            }
            if (this.f_58857_.m_5776_()) {
                this.playActivationSound(player);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onInteractBoth(state, world, pos, player, hand, hit, type);
    }

    protected abstract boolean isPortalSetter(ItemStack var1);

    protected abstract void playActivationSound(Player var1);

    public abstract List<BlockEntityMiniPortal> getPortalListA();

    public abstract List<BlockEntityMiniPortal> getPortalListB();

    protected abstract void findTargetPortal();

    public abstract void addThisPortalToLists();

    private boolean setPortal() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.getMachineState() != MachineState.ACTIVE) {
            this.findTargetPortal();
            this.setMachineState(MachineState.ACTIVE);
            return true;
        }
        return false;
    }

    protected boolean isSame(BlockEntityMiniPortal otherSide) {
        return otherSide.m_58900_().m_60734_() == this.m_58900_().m_60734_();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getMachineState() == MachineState.ACTIVE) {
            if (this.otherSide != null && this.otherSide.m_58901_()) {
                this.otherSide = null;
            } else if (this.otherSide == null && level.m_46467_() % 100L == 5L) {
                if (this.otherSidePos != null && this.otherSideDimension != null) {
                    BlockEntity blockEntity;
                    ServerLevel dimension = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)this.otherSideDimension));
                    if (dimension != null && level.m_46749_(this.otherSidePos) && (blockEntity = dimension.m_7702_(this.otherSidePos)) instanceof BlockEntityMiniPortal) {
                        BlockEntityMiniPortal portal;
                        this.otherSide = portal = (BlockEntityMiniPortal)blockEntity;
                        this.otherSideDimension = null;
                        this.otherSidePos = null;
                    }
                } else {
                    this.findTargetPortal();
                }
            }
        }
    }

    public void setMachineState(MachineState newState) {
        super.setMachineState(newState);
        if (this.f_58857_ != null) {
            this.invalidateCaps();
        }
    }

    public void onRemove() {
        super.onRemove();
        this.getPortalListA().remove((Object)this);
        this.getPortalListB().remove((Object)this);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.otherSide == null) {
            return;
        }
        CompoundTag otherSide = new CompoundTag();
        CompoundTag pos = new CompoundTag();
        pos.m_128405_("X", this.otherSide.m_58899_().m_123341_());
        pos.m_128405_("Y", this.otherSide.m_58899_().m_123342_());
        pos.m_128405_("Z", this.otherSide.m_58899_().m_123343_());
        otherSide.m_128365_("pos", (Tag)pos);
        otherSide.m_128359_("dimension", this.otherSide.m_58904_().m_46472_().m_135782_().toString());
        tag.m_128365_("otherSide", (Tag)otherSide);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!tag.m_128441_("otherSide")) {
            return;
        }
        CompoundTag otherSide = tag.m_128469_("otherSide");
        CompoundTag pos = otherSide.m_128469_("pos");
        this.otherSidePos = new BlockPos(pos.m_128451_("X"), pos.m_128451_("Y"), pos.m_128451_("Z"));
        this.otherSideDimension = new ResourceLocation(otherSide.m_128461_("dimension"));
    }

    public boolean toggleMachine() {
        return false;
    }

    public BlockEntity getExtendedBlockEntity(Direction side) {
        if (this.otherSide != null && !this.otherSide.m_58901_()) {
            return this.otherSide.getCachedBlockEntity(side);
        }
        return this;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        if (arg == null || this.getOtherSide() == null) {
            return LazyOptional.empty();
        }
        BlockEntity offset = this.getOtherSide().getCachedBlockEntity(arg.m_122424_());
        if (offset != null) {
            return offset.getCapability(capability, arg);
        }
        return LazyOptional.empty();
    }

    public List<String> getInfo(boolean simple) {
        List info = super.getInfo(simple);
        if (this.otherSide != null && !this.otherSide.m_58901_()) {
            info.add("Target at: x: " + this.otherSide.m_58899_().m_123341_() + " y: " + this.otherSide.m_58899_().m_123342_() + " z: " + this.otherSide.m_58899_().m_123343_() + " in " + this.otherSide.m_58904_().m_46472_().m_135782_());
        } else {
            info.add("No target");
        }
        return info;
    }

    @Generated
    public void setOtherSide(BlockEntityMiniPortal otherSide) {
        this.otherSide = otherSide;
    }
}

