/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.serializer.MachineRecipeSerializer;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityPrinter
extends BlockEntityMachine<BlockEntityPrinter>
implements IFilterableHandler {
    public BlockEntityPrinter(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityPrinter>(this){

            public IRecipe findRecipe() {
                IRecipe recipe = super.findRecipe();
                if (recipe == null) {
                    MachineItemHandler ih = (MachineItemHandler)BlockEntityPrinter.this.itemHandler.orElse(null);
                    ITrackedHandler inputHandler = ih.getInputHandler();
                    ItemStack paper = inputHandler.getStackInSlot(0);
                    ItemStack stored = inputHandler.getStackInSlot(1);
                    if (paper.m_41720_() == Items.f_42516_ && paper.m_41613_() >= 1 && stored.m_41720_() == GT5RItems.DataStick) {
                        CompoundTag prospect = stored.m_41737_("prospectData");
                        CompoundTag bookData = stored.m_41737_("bookData");
                        FluidStack ink = BlockEntityPrinter.this.fluidHandler.map(f -> f.getFluidInTank(0)).orElse(FluidStack.EMPTY);
                        if (!ink.isEmpty()) {
                            CompoundTag blueprintData;
                            if (ink.isFluidEqual(Materials.SquidInk.getLiquid(20)) && ink.getAmount() >= 144 && paper.m_41613_() >= 3) {
                                ItemStack output = new ItemStack(GT5RItems.PrintedPages);
                                if (prospect != null && prospect.m_128471_("analyzed")) {
                                    CompoundTag ores;
                                    CompoundTag nbt = output.m_41784_();
                                    nbt.m_128359_("filtered_title", "Analyzed Prospection Data");
                                    nbt.m_128359_("title", "Analyzed Prospection Data");
                                    BlockPos pos1 = BlockPos.m_122022_((long)prospect.m_128454_("pos"));
                                    nbt.m_128359_("author", "X: " + pos1.m_123341_() + " Y: " + pos1.m_123342_() + " Z: " + pos1.m_123343_() + " Dim: " + prospect.m_128461_("dimension"));
                                    nbt.m_128379_("resolved", true);
                                    ListTag pages = new ListTag();
                                    StringBuilder stringBuilder = new StringBuilder();
                                    if (prospect.m_128441_("fluid")) {
                                        CompoundTag fluid = prospect.m_128469_("fluid");
                                        FluidStack fluid1 = new FluidStack(RegistryUtils.getFluidFromID((ResourceLocation)new ResourceLocation(fluid.m_128461_("name"))), 1);
                                        pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Utils.translatable((String)"text.gt5r.prospected_book", (Object[])new Object[]{pos1.m_123341_(), pos1.m_123343_(), prospect.m_128461_("dimension"), fluid.m_128454_("maxYield"), Utils.translatable((String)fluid1.getTranslationKey(), (Object[])new Object[0])}))));
                                    } else {
                                        stringBuilder.append("Prospection Data From:");
                                        stringBuilder.append("\n").append("X: ").append(pos1.m_123341_()).append(" Z: ").append(pos1.m_123343_()).append(" Dim: ").append(prospect.m_128461_("dimension"));
                                        stringBuilder.append("\n").append("Produces ");
                                        stringBuilder.append("No oil");
                                        pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Utils.literal((String)stringBuilder.toString()))));
                                        stringBuilder = new StringBuilder();
                                    }
                                    if (prospect.m_128441_("ores") && !(ores = prospect.m_128469_("ores")).m_128456_()) {
                                        stringBuilder.append("Prospected Ores:\n");
                                        boolean addedFirst = false;
                                        for (String key : ores.m_128431_()) {
                                            Material m = Material.get((String)key);
                                            if (m == Material.NULL) continue;
                                            if (addedFirst) {
                                                stringBuilder.append(", ");
                                            }
                                            if (!addedFirst) {
                                                addedFirst = true;
                                            }
                                            stringBuilder.append(Utils.getLocalizedType((IGTObject)m));
                                        }
                                    }
                                    if (!stringBuilder.isEmpty()) {
                                        pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Utils.literal((String)stringBuilder.toString()))));
                                    }
                                    nbt.m_128365_("pages", (Tag)pages);
                                } else if (bookData != null) {
                                    output.m_41751_(bookData.m_6426_());
                                }
                                if (prospect != null && prospect.m_128471_("analyzed") || bookData != null) {
                                    return RecipeMaps.PRINTING.RB().recipeMapOnly().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42516_, (int)3)}).fi(new FluidStack[]{Materials.SquidInk.getLiquid(144)}).io(new ItemStack[]{output}).add("data_stick_book_printing", 400L, 2L);
                                }
                            } else if (ink.getFluid().m_205067_(GT5RTags.BLUE_DYE) && ink.getAmount() >= 144 && (blueprintData = stored.m_41737_("blueprintData")) != null) {
                                ItemStack output = new ItemStack((ItemLike)GTCoreItems.Blueprint);
                                output.m_41751_(blueprintData);
                                return RecipeMaps.PRINTING.RB().recipeMapOnly().ii(new ItemLike[]{Items.f_42516_}).fi(new FluidIngredient[]{FluidIngredient.of(GT5RTags.BLUE_DYE, (int)144)}).io(new ItemStack[]{output}).add("blueprint_printing", 400L, 2L);
                            }
                        }
                    }
                }
                return recipe;
            }

            public boolean accepts(ItemStack stack) {
                return super.accepts(stack) || stack.m_41720_() == Items.f_42516_ || stack.m_41720_() == GT5RItems.DataStick;
            }

            public void onMachineEvent(IMachineEvent event, Object ... data) {
                Integer integer;
                Object object;
                if (event == SlotType.IT_IN && (object = data[0]) instanceof Integer && (integer = (Integer)object) == 1) {
                    this.lastRecipe = null;
                }
                super.onMachineEvent(event, data);
            }

            public CompoundTag serialize() {
                CompoundTag nbt = super.serialize();
                if (this.activeRecipe != null) {
                    nbt.m_128359_("activeRecipe", this.activeRecipe.toJson().toString());
                }
                if (this.lastRecipe != null) {
                    nbt.m_128359_("lastRecipe", this.lastRecipe.toJson().toString());
                }
                return nbt;
            }

            public void deserialize(CompoundTag nbt) {
                super.deserialize(nbt);
                if (nbt.m_128441_("activeRecipe")) {
                    this.activeRecipe = MachineRecipeSerializer.INSTANCE.fromJson(new ResourceLocation(nbt.m_128461_("AR")), (JsonObject)JsonParser.parseString((String)nbt.m_128461_("activeRecipe")));
                }
                if (nbt.m_128441_("lastRecipe")) {
                    this.lastRecipe = MachineRecipeSerializer.INSTANCE.fromJson(new ResourceLocation(nbt.m_128461_("LR")), (JsonObject)JsonParser.parseString((String)nbt.m_128461_("lastRecipe")));
                }
            }
        });
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        if (slotType == SlotType.IT_IN) {
            return slot == 0 == (stack.m_41720_() != GT5RItems.DataStick);
        }
        return true;
    }
}

