/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class ScreenWrapper
extends Screen
implements IScreenWrapper {
    private final BaseScreen wrappedGui;
    private final TooltipList tooltipList = new TooltipList();

    public ScreenWrapper(BaseScreen g) {
        super(g.getTitle());
        this.wrappedGui = g;
    }

    public void m_7856_() {
        super.m_7856_();
        this.wrappedGui.itemRenderer = this.f_96542_;
        this.wrappedGui.initGui();
    }

    public boolean m_7043_() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean m_6375_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        return this.wrappedGui.mousePressed(MouseButton.get(button)) || super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.m_6348_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        return this.wrappedGui.mouseScrolled(scroll) || super.m_6050_(x, y, scroll);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Object object;
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
            return true;
        }
        if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(true);
            return true;
        }
        if (Platform.isModLoaded((String)"jei") && (object = WrappedIngredient.unwrap(this.wrappedGui.getIngredientUnderMouse())) != null) {
            this.handleIngredientKey(key, object);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.m_5534_(keyChar, (int)keyChar);
    }

    private void handleIngredientKey(Key key, Object object) {
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        this.m_7333_(matrixStack);
        GuiHelper.setupDrawing();
        int x = this.wrappedGui.getX();
        int y = this.wrappedGui.getY();
        int w = this.wrappedGui.width;
        int h = this.wrappedGui.height;
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.draw(matrixStack, theme, x, y, w, h);
        this.wrappedGui.drawForeground(matrixStack, theme, x, y, w, h);
        ((Panel)Objects.requireNonNullElse(this.wrappedGui.contextMenu, this.wrappedGui)).addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            Object ingredient;
            Object object = this.wrappedGui.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap(object)) instanceof ItemStack && !((ItemStack)ingredient).m_41619_()) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.0, (double)this.tooltipList.zOffsetItemTooltip);
                this.m_6057_(matrixStack, (ItemStack)ingredient, mouseX, mouseY);
                matrixStack.m_85849_();
            }
        } else {
            this.tooltipList.render(matrixStack, mouseX, Math.max(mouseY, 18), this.wrappedGui.getScreen().m_85445_(), this.wrappedGui.getScreen().m_85446_(), theme.getFont());
        }
        this.tooltipList.reset();
    }

    public void m_7333_(PoseStack matrixStack) {
        if (this.wrappedGui.drawDefaultBackground(matrixStack)) {
            super.m_7333_(matrixStack);
        }
    }

    public void m_96624_() {
        super.m_96624_();
        this.wrappedGui.tick();
    }

    @Override
    public BaseScreen getGui() {
        return this.wrappedGui;
    }

    public void m_7861_() {
        this.wrappedGui.onClosed();
        super.m_7861_();
    }
}

