/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.recipe.IgnoredRecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.ShapedRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.ShapelessRecipeJS;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class RecipeTypeRegistryEventJS
extends EventJS {
    private final Map<ResourceLocation, RecipeTypeJS> map;

    public RecipeTypeRegistryEventJS(Map<ResourceLocation, RecipeTypeJS> m) {
        this.map = m;
    }

    public void register(RecipeTypeJS type) {
        this.map.put(Registries.getId(type.serializer, (ResourceKey)Registry.f_122915_), type);
        KubeJS.LOGGER.info("Registered custom recipe handler for type " + type);
    }

    public void register(ResourceLocation id, Supplier<RecipeJS> f) {
        this.register(new RecipeTypeJS(Objects.requireNonNull((RecipeSerializer)KubeJSRegistries.recipeSerializers().get(id), "Cannot find recipe serializer: " + id), f));
    }

    public void ignore(ResourceLocation id) {
        this.register(new IgnoredRecipeTypeJS(Objects.requireNonNull((RecipeSerializer)KubeJSRegistries.recipeSerializers().get(id), "Cannot find recipe serializer: " + id)));
    }

    public void registerShaped(ResourceLocation id) {
        this.register(id, ShapedRecipeJS::new);
    }

    public void registerShapeless(ResourceLocation id) {
        this.register(id, ShapelessRecipeJS::new);
    }
}

