/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient.forge;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class IgnoreNBTIngredient
extends Ingredient {
    public static final IIngredientSerializer<IgnoreNBTIngredient> SERIALIZER = new IIngredientSerializer<IgnoreNBTIngredient>(){

        public IgnoreNBTIngredient parse(FriendlyByteBuf buf) {
            ItemStack stack = buf.m_130267_();
            stack.m_41751_(null);
            return new IgnoreNBTIngredient(stack);
        }

        public IgnoreNBTIngredient parse(JsonObject json) {
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("item").getAsString())));
            stack.m_41751_(null);
            return new IgnoreNBTIngredient(stack);
        }

        public void write(FriendlyByteBuf buf, IgnoreNBTIngredient ingredient) {
            buf.m_130055_(ingredient.item);
        }
    };
    private final ItemStack item;

    public IgnoreNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.item = stack;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && !stack.m_41619_() && stack.m_41720_() == this.item.m_41720_();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "kubejs:ignore_nbt");
        json.addProperty("item", this.item.m_41720_().getRegistryName().toString());
        return json;
    }
}

