/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import dev.architectury.core.block.ArchitecturyLiquidBlock;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockItemBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class FluidBlockBuilder
extends BlockBuilder {
    private final FluidBuilder fluidBuilder;

    public FluidBlockBuilder(FluidBuilder b) {
        super(b.id);
        this.fluidBuilder = b;
        this.defaultTranslucent();
        this.noItem();
        this.noDrops();
    }

    @Override
    public Block createObject() {
        return new ArchitecturyLiquidBlock((Supplier)UtilsJS.cast(this.fluidBuilder.flowingFluid), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_());
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.blockState(this.id, m -> m.variant("", this.id.m_135827_() + ":block/" + this.id.m_135815_()));
        generator.blockModel(this.id, m -> {
            m.parent("");
            m.texture("particle", this.fluidBuilder.stillTexture.toString());
        });
    }

    @Override
    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        if (i != null) {
            throw new IllegalStateException("Fluid blocks cannot have items!");
        }
        return super.item(null);
    }
}

