/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import java.util.Objects;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class ComponentWrapper {
    public static MutableComponent of(@Nullable Object o) {
        MapJS map;
        if ((o = UtilsJS.wrap(o, JSObjectType.ANY)) == null) {
            return new TextComponent("null");
        }
        if (o instanceof Component) {
            Component component = (Component)o;
            return component.m_6881_();
        }
        if (o instanceof CharSequence || o instanceof Number || o instanceof Character) {
            return new TextComponent(o.toString());
        }
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            return new TextComponent(e.name());
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            String s = tag.m_7916_();
            if (s.startsWith("{") && s.endsWith("}")) {
                try {
                    return Component.Serializer.m_130701_((String)s);
                }
                catch (JsonParseException ex) {
                    return new TextComponent("Error: " + ex);
                }
            }
            return new TextComponent(s);
        }
        if (o instanceof ListJS) {
            ListJS list = (ListJS)o;
            MutableComponent text = TextComponent.f_131282_.m_6881_();
            for (Object e1 : list) {
                text.m_7220_((Component)ComponentWrapper.of(e1));
            }
            return text;
        }
        if (o instanceof MapJS && ((map = (MapJS)o).containsKey("text") || map.containsKey("translate"))) {
            TextComponent text;
            if (map.containsKey("text")) {
                text = new TextComponent(map.get("text").toString());
            } else {
                Object[] with;
                if (map.containsKey("with")) {
                    ListJS a = map.getOrNewList("with");
                    with = new Object[a.size()];
                    int i = 0;
                    for (Object e1 : a) {
                        with[i] = e1;
                        if (with[i] instanceof MapJS || with[i] instanceof ListJS) {
                            with[i] = ComponentWrapper.of(e1);
                        }
                        ++i;
                    }
                } else {
                    with = new Object[]{};
                }
                text = new TranslatableComponent(map.get("translate").toString(), with);
            }
            if (map.containsKey("color")) {
                text.color(ColorWrapper.of(map.get("color")));
            }
            text.bold((Boolean)map.getOrDefault("bold", null));
            text.italic((Boolean)map.getOrDefault("italic", null));
            text.underlined((Boolean)map.getOrDefault("underlined", null));
            text.strikethrough((Boolean)map.getOrDefault("strikethrough", null));
            text.obfuscated((Boolean)map.getOrDefault("obfuscated", null));
            text.insertion((String)map.getOrDefault("insertion", null));
            text.font(map.containsKey("font") ? new ResourceLocation(map.get("font").toString()) : null);
            text.click(map.containsKey("click") ? ComponentWrapper.clickEventOf(map.get("click")) : null);
            text.hover(map.containsKey("hover") ? ComponentWrapper.of(map.get("hover")) : null);
            if (map.containsKey("extra")) {
                for (Object e : map.getOrNewList("extra")) {
                    text.m_7220_((Component)ComponentWrapper.of(e));
                }
            }
            return text;
        }
        return new TextComponent(o.toString());
    }

    public static ClickEvent clickEventOf(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClickEvent) {
            ClickEvent ce = (ClickEvent)o;
            return ce;
        }
        JsonObject json = MapJS.json(o);
        if (json != null) {
            String action = GsonHelper.m_13906_((JsonObject)json, (String)"action");
            String value = GsonHelper.m_13906_((JsonObject)json, (String)"value");
            return new ClickEvent(Objects.requireNonNull(ClickEvent.Action.m_130645_((String)action), "Invalid click event action %s!".formatted(action)), value);
        }
        String s = o.toString();
        String[] split = s.split(":", 2);
        return switch (split[0]) {
            case "command" -> new ClickEvent(ClickEvent.Action.RUN_COMMAND, split[1]);
            case "suggest_command" -> new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, split[1]);
            case "copy" -> new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, split[1]);
            case "file" -> new ClickEvent(ClickEvent.Action.OPEN_FILE, split[1]);
            default -> {
                ClickEvent.Action action = ClickEvent.Action.m_130645_((String)split[0]);
                if (action != null) {
                    yield new ClickEvent(action, split[1]);
                }
                yield new ClickEvent(ClickEvent.Action.OPEN_URL, s);
            }
        };
    }

    public static Component prettyPrintNbt(Tag tag) {
        return NbtUtils.m_178061_((Tag)tag);
    }

    public static MutableComponent join(MutableComponent separator, Iterable<? extends Component> texts) {
        MutableComponent joined = TextComponent.f_131282_.m_6879_();
        boolean first = true;
        for (Component component : texts) {
            if (first) {
                first = false;
            } else {
                joined.m_7220_((Component)separator);
            }
            joined.m_7220_(component);
        }
        return joined;
    }

    public static MutableComponent string(String text) {
        return new TextComponent(text);
    }

    public static MutableComponent translate(String key) {
        return new TranslatableComponent(key, new Object[0]);
    }

    public static MutableComponent translate(String key, Object ... objects) {
        return new TranslatableComponent(key, objects);
    }

    public static MutableComponent keybind(String keybind) {
        return new KeybindComponent(keybind);
    }

    public static MutableComponent black(Object text) {
        return ComponentWrapper.of(text).black();
    }

    public static MutableComponent darkBlue(Object text) {
        return ComponentWrapper.of(text).darkBlue();
    }

    public static MutableComponent darkGreen(Object text) {
        return ComponentWrapper.of(text).darkGreen();
    }

    public static MutableComponent darkAqua(Object text) {
        return ComponentWrapper.of(text).darkAqua();
    }

    public static MutableComponent darkRed(Object text) {
        return ComponentWrapper.of(text).darkRed();
    }

    public static MutableComponent darkPurple(Object text) {
        return ComponentWrapper.of(text).darkPurple();
    }

    public static MutableComponent gold(Object text) {
        return ComponentWrapper.of(text).gold();
    }

    public static MutableComponent gray(Object text) {
        return ComponentWrapper.of(text).gray();
    }

    public static MutableComponent darkGray(Object text) {
        return ComponentWrapper.of(text).darkGray();
    }

    public static MutableComponent blue(Object text) {
        return ComponentWrapper.of(text).blue();
    }

    public static MutableComponent green(Object text) {
        return ComponentWrapper.of(text).green();
    }

    public static MutableComponent aqua(Object text) {
        return ComponentWrapper.of(text).aqua();
    }

    public static MutableComponent red(Object text) {
        return ComponentWrapper.of(text).red();
    }

    public static MutableComponent lightPurple(Object text) {
        return ComponentWrapper.of(text).lightPurple();
    }

    public static MutableComponent yellow(Object text) {
        return ComponentWrapper.of(text).yellow();
    }

    public static MutableComponent white(Object text) {
        return ComponentWrapper.of(text).white();
    }
}

