/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.recipes.builder.RecipeLayoutBuilder;
import mezz.jei.ingredients.IIngredientSupplier;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.recipes.FocusGroup;
import mezz.jei.util.RecipeErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class IngredientSupplierHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    private IngredientSupplierHelper() {
    }

    @Nullable
    public static <T> IIngredientSupplier getIngredientSupplier(T recipe, IRecipeCategory<T> recipeCategory, RegisteredIngredients registeredIngredients) {
        try {
            RecipeLayoutBuilder builder = new RecipeLayoutBuilder(registeredIngredients, 0);
            recipeCategory.setRecipe((IRecipeLayoutBuilder)builder, recipe, FocusGroup.EMPTY);
            if (builder.isUsed()) {
                return builder;
            }
        }
        catch (LinkageError | RuntimeException e) {
            String recipeName = RecipeErrorUtil.getNameForRecipe(recipe);
            LOGGER.error("Found a broken recipe, failed to setRecipe with RecipeLayoutBuilder: {}\n", (Object)recipeName, (Object)e);
        }
        return IngredientSupplierHelper.getLegacyIngredientSupplier(recipe, recipeCategory);
    }

    @Nullable
    public static <T> IIngredientSupplier getLegacyIngredientSupplier(T recipe, IRecipeCategory<T> recipeCategory) {
        try {
            Ingredients ingredients = new Ingredients();
            recipeCategory.setIngredients(recipe, ingredients);
            return ingredients;
        }
        catch (LinkageError | RuntimeException e) {
            String recipeName = RecipeErrorUtil.getNameForRecipe(recipe);
            LOGGER.error("Found a broken recipe, failed to set Ingredients: {}\n", (Object)recipeName, (Object)e);
            return null;
        }
    }
}

