/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.util.concurrent.CompletableFuture;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.util.ServerCommandUtil;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketDeletePlayerItem
extends PacketJei {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ItemStack itemStack;

    public PacketDeletePlayerItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.DELETE_ITEM;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        IPlatformRegistry<Item> registry = Services.PLATFORM.getRegistry(Registry.f_122904_);
        int itemId = registry.getId(this.itemStack.m_41720_());
        buf.m_130130_(itemId);
    }

    public static CompletableFuture<Void> readPacketData(ServerPacketData data) {
        FriendlyByteBuf buf = data.buf();
        ServerPacketContext context = data.context();
        ServerPlayer player = context.player();
        int itemId = buf.m_130242_();
        return Services.PLATFORM.getRegistry(Registry.f_122904_).getValue(itemId).map(item -> {
            MinecraftServer server = player.f_8924_;
            return server.m_18707_(() -> PacketDeletePlayerItem.deletePlayerItem(player, context, item));
        }).orElseGet(() -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Player '{} ({})' tried to delete Item ID '{}' but no item is registered with that ID.", (Object)player.m_7755_(), (Object)player.m_142081_(), (Object)itemId);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private static void deletePlayerItem(ServerPlayer player, ServerPacketContext context, Item item) {
        IServerConfig serverConfig = context.serverConfig();
        if (ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig)) {
            ItemStack playerItem = player.f_36096_.m_142621_();
            if (playerItem.m_41720_() == item) {
                player.f_36096_.m_142503_(ItemStack.f_41583_);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Player '{} ({})' tried to delete Item '{}' but is currently holding a different ItemStack '{}'.", (Object)player.m_7755_(), (Object)player.m_142081_(), (Object)item, (Object)playerItem.m_41611_());
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                ItemStack playerItem = player.f_36096_.m_142621_();
                LOGGER.debug("Player '{} ({})' tried to delete ItemStack '{}' but does not have permission.", (Object)player.m_7755_(), (Object)player.m_142081_(), (Object)playerItem.m_41611_());
            }
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false), player);
        }
    }
}

