/*
 * Decompiled with CFR 0.152.
 */
package dev.trinsdar.bicclipboard.clipboard;

import dev.trinsdar.bicclipboard.BiCClipboardUtils;
import dev.trinsdar.bicclipboard.clipboard.CheckboxState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public record ClipboardContent(String title, int active, List<Page> pages) {
    public static final int MAX_PAGES = 50;
    public static final int MAX_LINES = 9;
    public static final ClipboardContent DEFAULT = new ClipboardContent("", 0, List.of(Page.DEFAULT));

    public ClipboardContent setTitle(String title) {
        return new ClipboardContent(title, this.active, this.pages);
    }

    public ClipboardContent setActive(int active) {
        return new ClipboardContent(this.title, active, this.pages);
    }

    public boolean canHaveNewPage() {
        return this.active < this.pages.size() - 1 || this.pages.size() - 1 < 50;
    }

    public ClipboardContent nextPage() {
        if (this.active >= this.pages.size() - 1 && this.canHaveNewPage()) {
            ArrayList<Page> list = new ArrayList<Page>(this.pages);
            list.add(Page.DEFAULT);
            return this.setActive(list.size() - 1).setPages(list);
        }
        return this.active >= this.pages.size() - 1 ? this : this.setActive(this.active + 1);
    }

    public ClipboardContent prevPage() {
        return this.active == 0 ? this : this.setActive(this.active - 1);
    }

    public ClipboardContent setPages(List<Page> pages) {
        return new ClipboardContent(this.title, this.active, pages);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("title", this.title);
        tag.m_128405_("active", this.active);
        ListTag list = new ListTag();
        for (Page page : this.pages) {
            list.add((Object)page.serialize());
        }
        tag.m_128365_("pages", (Tag)list);
        return tag;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.title);
        buf.m_130130_(this.active);
        buf.m_130130_(this.pages.size());
        for (Page page : this.pages) {
            page.encode(buf);
        }
    }

    public static ClipboardContent fromStack(ItemStack stack) {
        CompoundTag clipboardTag = stack.m_41737_("clipboardContent");
        return clipboardTag != null ? ClipboardContent.deserialize(clipboardTag) : DEFAULT;
    }

    public static ClipboardContent deserialize(CompoundTag tag) {
        String title = tag.m_128461_("title");
        int active = tag.m_128451_("active");
        ListTag list = tag.m_128437_("pages", 10);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (Tag t : list) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)t;
            pages.add(Page.deserialize(compoundTag));
        }
        return new ClipboardContent(title, active, pages);
    }

    public static ClipboardContent decode(FriendlyByteBuf buf) {
        String title = buf.m_130277_();
        int active = buf.m_130242_();
        int pageCount = buf.m_130242_();
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < pageCount; ++i) {
            pages.add(Page.decode(buf));
        }
        return new ClipboardContent(title, active, pages);
    }

    public record Page(List<CheckboxState> checkboxes, List<String> lines) {
        public static final Page DEFAULT = new Page(new ArrayList<CheckboxState>(9), new ArrayList<String>(9));

        public Page(List<CheckboxState> checkboxes, List<String> lines) {
            this.checkboxes = BiCClipboardUtils.extend(checkboxes, 9, CheckboxState.EMPTY);
            this.lines = BiCClipboardUtils.extend(lines, 9, "");
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            ListTag checkboxesTag = new ListTag();
            for (CheckboxState checkbox : this.checkboxes) {
                checkboxesTag.add((Object)IntTag.m_128679_((int)checkbox.ordinal()));
            }
            tag.m_128365_("checkboxes", (Tag)checkboxesTag);
            ListTag linesTag = new ListTag();
            for (String line : this.lines) {
                linesTag.add((Object)StringTag.m_129297_((String)line));
            }
            tag.m_128365_("lines", (Tag)linesTag);
            return tag;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130130_(this.checkboxes.size());
            for (CheckboxState checkbox : this.checkboxes) {
                buf.m_130130_(checkbox.ordinal());
            }
            buf.m_130130_(this.lines.size());
            for (String line : this.lines) {
                buf.m_130070_(line);
            }
        }

        public static Page deserialize(CompoundTag tag) {
            ListTag checkboxesTag = tag.m_128437_("checkboxes", 3);
            if (checkboxesTag.isEmpty()) {
                checkboxesTag = tag.m_128437_("checkboxes", 8);
            }
            ArrayList<CheckboxState> checkboxes = new ArrayList<CheckboxState>();
            for (Tag t : checkboxesTag) {
                if (t instanceof StringTag) {
                    StringTag stringTag = (StringTag)t;
                    checkboxes.add(CheckboxState.valueOf(stringTag.m_7916_().toUpperCase()));
                    continue;
                }
                if (!(t instanceof IntTag)) continue;
                IntTag intTag = (IntTag)t;
                checkboxes.add(CheckboxState.values()[intTag.m_7047_()]);
            }
            ListTag linesTag = tag.m_128437_("lines", 8);
            ArrayList<String> lines = new ArrayList<String>();
            for (Tag t : linesTag) {
                if (!(t instanceof StringTag)) continue;
                StringTag stringTag = (StringTag)t;
                lines.add(stringTag.m_7916_());
            }
            return new Page(checkboxes, lines);
        }

        public static Page decode(FriendlyByteBuf buf) {
            int size = buf.m_130242_();
            ArrayList<CheckboxState> checkboxes = new ArrayList<CheckboxState>();
            for (int i = 0; i < size; ++i) {
                checkboxes.add(CheckboxState.values()[buf.m_130242_()]);
            }
            size = buf.m_130242_();
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                lines.add(buf.m_130277_());
            }
            return new Page(checkboxes, lines);
        }

        public Page setCheckboxes(List<CheckboxState> checkboxes) {
            return new Page(checkboxes, this.lines);
        }

        public Page setLines(List<String> lines) {
            return new Page(this.checkboxes, lines);
        }
    }
}

