/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.chute;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class ChuteBlock
extends AbstractChuteBlock
implements ProperWaterloggedBlock {
    public static final Property<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61373_;

    public ChuteBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)Shape.NORMAL))).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    @Override
    public boolean isOpen(BlockState state) {
        return state.m_61143_((Property)FACING) == Direction.DOWN || state.m_61143_(SHAPE) == Shape.INTERSECTION;
    }

    @Override
    public boolean isTransparent(BlockState state) {
        return state.m_61143_(SHAPE) == Shape.WINDOW;
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        boolean down;
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        boolean bl = down = state.m_61143_((Property)FACING) == Direction.DOWN;
        if (shape == Shape.INTERSECTION) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (shape == Shape.ENCASED) {
            level.m_46597_(context.m_8083_(), (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORMAL)));
            level.m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)AllBlocks.INDUSTRIAL_IRON_BLOCK.getDefaultState()));
            return InteractionResult.SUCCESS;
        }
        if (down) {
            level.m_46597_(context.m_8083_(), (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(shape != Shape.NORMAL ? Shape.NORMAL : Shape.WINDOW))));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        if (!AllBlocks.INDUSTRIAL_IRON_BLOCK.isIn(player.m_21120_(hand))) {
            return super.m_6227_(state, level, pos, player, hand, hitResult);
        }
        if (shape == Shape.INTERSECTION || shape == Shape.ENCASED) {
            return super.m_6227_(state, level, pos, player, hand, hitResult);
        }
        if (player == null || level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.ENCASED)));
        level.m_5594_(null, pos, SoundEvents.f_12201_, SoundSource.BLOCKS, 0.5f, 1.05f);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = this.withWater(super.m_5573_(ctx), ctx);
        Direction face = ctx.m_43719_();
        if (face.m_122434_().m_122479_() && !ctx.m_7078_()) {
            Level world = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            return this.updateChuteState((BlockState)state.m_61124_((Property)FACING, (Comparable)face), world.m_8055_(pos.m_7494_()), (BlockGetter)world, pos);
        }
        return state;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState above, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        this.updateWater(world, state, pos);
        return super.m_7417_(state, direction, above, world, pos, p_196271_6_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_.m_61104_(new Property[]{SHAPE, FACING, WATERLOGGED}));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState above = world.m_8055_(pos.m_7494_());
        return !ChuteBlock.isChute(above) || ChuteBlock.getChuteFacing(above) == Direction.DOWN;
    }

    @Override
    public BlockState updateChuteState(BlockState state, BlockState above, BlockGetter world, BlockPos pos) {
        boolean noConnections;
        BlockState target;
        boolean vertical;
        if (!(state.m_60734_() instanceof ChuteBlock)) {
            return state;
        }
        HashMap<BlockState, Boolean> connections = new HashMap<BlockState, Boolean>();
        int amtConnections = 0;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean bl = vertical = facing == Direction.DOWN;
        if (!vertical && !ChuteBlock.isChute(target = world.m_8055_(pos.m_7495_().m_142300_(facing.m_122424_())))) {
            return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_(SHAPE, (Comparable)((Object)Shape.NORMAL));
        }
        for (BlockState direction : Iterate.horizontalDirections) {
            BlockState diagonalInputChute = world.m_8055_(pos.m_7494_().m_142300_((Direction)direction));
            boolean value = diagonalInputChute.m_60734_() instanceof ChuteBlock && diagonalInputChute.m_61143_((Property)FACING) == direction;
            connections.put(direction, value);
            if (!value) continue;
            ++amtConnections;
        }
        boolean bl2 = noConnections = amtConnections == 0;
        if (vertical) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(noConnections ? (state.m_61143_(SHAPE) == Shape.INTERSECTION ? Shape.NORMAL : (Shape)((Object)state.m_61143_(SHAPE))) : Shape.INTERSECTION)));
        }
        if (noConnections) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.NORTH)).booleanValue() && ((Boolean)connections.get(Direction.SOUTH)).booleanValue()) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.EAST)).booleanValue() && ((Boolean)connections.get(Direction.WEST)).booleanValue()) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (amtConnections == 1 && ((Boolean)connections.get(facing)).booleanValue() && ChuteBlock.getChuteFacing(above) != Direction.DOWN && (!(above.m_60734_() instanceof FunnelBlock) || FunnelBlock.getFunnelFacing(above) != Direction.DOWN)) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(state.m_61143_(SHAPE) == Shape.ENCASED ? Shape.ENCASED : Shape.NORMAL)));
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public BlockEntityType<? extends ChuteBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.CHUTE.get();
    }

    public static enum Shape implements StringRepresentable
    {
        INTERSECTION,
        WINDOW,
        NORMAL,
        ENCASED;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

