/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainDrive;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.chainDrive.ChainGearshiftBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class ChainDriveBlock
extends RotatedPillarKineticBlock
implements IBE<KineticBlockEntity>,
ITransformableBlock {
    public static final Property<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final BooleanProperty CONNECTED_ALONG_FIRST_COORDINATE = DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;

    public ChainDriveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.NONE)));
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.NORMAL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{PART, CONNECTED_ALONG_FIRST_COORDINATE}));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis axis;
        Direction.Axis placedAxis = context.m_7820_().m_122434_();
        Direction.Axis axis2 = axis = context.m_43723_() != null && context.m_43723_().m_6144_() ? placedAxis : ChainDriveBlock.getPreferredAxis(context);
        if (axis == null) {
            axis = placedAxis;
        }
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)AXIS, (Comparable)axis);
        for (Direction facing : Iterate.directions) {
            if (facing.m_122434_() == axis) continue;
            BlockPos pos = context.m_8083_();
            BlockPos offset = pos.m_142300_(facing);
            state = this.m_7417_(state, facing, context.m_43725_().m_8055_(offset), (LevelAccessor)context.m_43725_(), pos, offset);
        }
        return state;
    }

    public BlockState m_7417_(BlockState stateIn, Direction face, BlockState neighbour, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis otherConnectionAxis;
        boolean positive;
        Part part = (Part)((Object)stateIn.m_61143_(PART));
        Direction.Axis axis = (Direction.Axis)stateIn.m_61143_((Property)AXIS);
        boolean connectionAlongFirst = (Boolean)stateIn.m_61143_((Property)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        Direction.Axis faceAxis = face.m_122434_();
        boolean facingAlongFirst = axis == Direction.Axis.X ? faceAxis.m_122478_() : faceAxis == Direction.Axis.X;
        boolean bl = positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (axis == faceAxis) {
            return stateIn;
        }
        if (!(neighbour.m_60734_() instanceof ChainDriveBlock)) {
            if (facingAlongFirst != connectionAlongFirst || part == Part.NONE) {
                return stateIn;
            }
            if (part == Part.MIDDLE) {
                return (BlockState)stateIn.m_61124_(PART, (Comparable)((Object)(positive ? Part.END : Part.START)));
            }
            if (part == Part.START == positive) {
                return (BlockState)stateIn.m_61124_(PART, (Comparable)((Object)Part.NONE));
            }
            return stateIn;
        }
        Part otherPart = (Part)((Object)neighbour.m_61143_(PART));
        Direction.Axis otherAxis = (Direction.Axis)neighbour.m_61143_((Property)AXIS);
        boolean otherConnection = (Boolean)neighbour.m_61143_((Property)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis axis2 = otherConnection ? (otherAxis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (otherConnectionAxis = otherAxis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        if (neighbour.m_61143_((Property)AXIS) == faceAxis) {
            return stateIn;
        }
        if (otherPart != Part.NONE && otherConnectionAxis != faceAxis) {
            return stateIn;
        }
        if (part == Part.NONE) {
            Part part2 = part = positive ? Part.START : Part.END;
            connectionAlongFirst = axis == Direction.Axis.X ? faceAxis.m_122478_() : faceAxis == Direction.Axis.X;
        } else if (connectionAxis != faceAxis) {
            return stateIn;
        }
        if (part == Part.START != positive) {
            part = Part.MIDDLE;
        }
        return (BlockState)((BlockState)stateIn.m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(connectionAlongFirst));
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (originalState.m_61143_(PART) == Part.NONE) {
            return super.getRotatedBlockState(originalState, targetedFace);
        }
        return super.getRotatedBlockState(originalState, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)ChainDriveBlock.getConnectionAxis(originalState)));
    }

    @Override
    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        Direction.Axis axis = (Direction.Axis)newState.m_61143_((Property)AXIS);
        newState = (BlockState)this.m_49966_().m_61124_((Property)AXIS, (Comparable)axis);
        if (newState.m_61138_((Property)BlockStateProperties.f_61448_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())));
        }
        for (Direction facing : Iterate.directions) {
            if (facing.m_122434_() == axis) continue;
            BlockPos pos = context.m_8083_();
            BlockPos offset = pos.m_142300_(facing);
            newState = this.m_7417_(newState, facing, context.m_43725_().m_8055_(offset), (LevelAccessor)context.m_43725_(), pos, offset);
        }
        return newState;
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == state.m_61143_((Property)AXIS);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)AXIS);
    }

    public static boolean areBlocksConnected(BlockState state, BlockState other, Direction facing) {
        Part part = (Part)((Object)state.m_61143_(PART));
        Direction.Axis connectionAxis = ChainDriveBlock.getConnectionAxis(state);
        Direction.Axis otherConnectionAxis = ChainDriveBlock.getConnectionAxis(other);
        if (otherConnectionAxis != connectionAxis) {
            return false;
        }
        if (facing.m_122434_() != connectionAxis) {
            return false;
        }
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE && (part == Part.MIDDLE || part == Part.START)) {
            return true;
        }
        return facing.m_122421_() == Direction.AxisDirection.NEGATIVE && (part == Part.MIDDLE || part == Part.END);
    }

    protected static Direction.Axis getConnectionAxis(BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        boolean connectionAlongFirst = (Boolean)state.m_61143_((Property)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        return connectionAxis;
    }

    public static float getRotationSpeedModifier(KineticBlockEntity from, KineticBlockEntity to) {
        float fromMod = 1.0f;
        float toMod = 1.0f;
        if (from instanceof ChainGearshiftBlockEntity) {
            fromMod = ((ChainGearshiftBlockEntity)from).getModifier();
        }
        if (to instanceof ChainGearshiftBlockEntity) {
            toMod = ((ChainGearshiftBlockEntity)to).getModifier();
        }
        return fromMod / toMod;
    }

    @Override
    public Class<KineticBlockEntity> getBlockEntityClass() {
        return KineticBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.ENCASED_SHAFT.get();
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, rot, Direction.Axis.Y);
    }

    protected BlockState rotate(BlockState pState, Rotation rot, Direction.Axis rotAxis) {
        Direction.Axis connectionAxis = ChainDriveBlock.getConnectionAxis(pState);
        Direction direction = Direction.m_122387_((Direction.Axis)connectionAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction normal = Direction.m_122387_((Direction.Axis)((Direction.Axis)pState.m_61143_((Property)AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        for (int i = 0; i < rot.ordinal(); ++i) {
            direction = direction.m_175362_(rotAxis);
            normal = normal.m_175362_(rotAxis);
        }
        if (direction.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            pState = this.reversePart(pState);
        }
        Direction.Axis newAxis = normal.m_122434_();
        Direction.Axis newConnectingDirection = direction.m_122434_();
        boolean alongFirst = newAxis == Direction.Axis.X && newConnectingDirection == Direction.Axis.Y || newAxis != Direction.Axis.X && newConnectingDirection == Direction.Axis.X;
        return (BlockState)((BlockState)pState.m_61124_((Property)AXIS, (Comparable)newAxis)).m_61124_((Property)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(alongFirst));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        Direction.Axis connectionAxis = ChainDriveBlock.getConnectionAxis(pState);
        if (pMirror.m_54848_(Direction.m_122387_((Direction.Axis)connectionAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122421_() == Direction.AxisDirection.POSITIVE) {
            return pState;
        }
        return this.reversePart(pState);
    }

    protected BlockState reversePart(BlockState pState) {
        Part part = (Part)((Object)pState.m_61143_(PART));
        if (part == Part.START) {
            return (BlockState)pState.m_61124_(PART, (Comparable)((Object)Part.END));
        }
        if (part == Part.END) {
            return (BlockState)pState.m_61124_(PART, (Comparable)((Object)Part.START));
        }
        return pState;
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return this.rotate(this.m_6943_(state, transform.mirror), transform.rotation, transform.rotationAxis);
    }

    public static enum Part implements StringRepresentable
    {
        START,
        MIDDLE,
        END,
        NONE;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

