/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.wrench;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public interface IWrenchable {
    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockState rotated = this.getRotatedBlockState(state, context.m_43719_());
        if (!rotated.m_60710_((LevelReader)world, context.m_8083_())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState(world, context.m_8083_(), this.updateAfterWrenched(rotated, context));
        BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
        if (be instanceof GeneratingKineticBlockEntity) {
            ((GeneratingKineticBlockEntity)be).reActivateSource = true;
        }
        if (world.m_8055_(context.m_8083_()) != state) {
            this.playRotateSound(world, context.m_8083_());
        }
        return InteractionResult.SUCCESS;
    }

    default public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return Block.m_49931_((BlockState)newState, (LevelAccessor)context.m_43725_(), (BlockPos)context.m_8083_());
    }

    default public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && !player.m_7500_()) {
            Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
        }
        state.m_60612_(serverLevel, pos, ItemStack.f_41583_);
        world.m_46961_(pos, false);
        this.playRemoveSound(world, pos);
        return InteractionResult.SUCCESS;
    }

    default public void playRemoveSound(Level world, BlockPos pos) {
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, (Vec3i)pos, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
    }

    default public void playRotateSound(Level world, BlockPos pos) {
        AllSoundEvents.WRENCH_ROTATE.playOnServer(world, (Vec3i)pos, 1.0f, Create.RANDOM.nextFloat() + 0.5f);
    }

    default public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        BlockState newState = originalState;
        if (targetedFace.m_122434_() == Direction.Axis.Y) {
            if (originalState.m_61138_(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)) {
                return (BlockState)originalState.m_61124_(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)originalState.m_61143_(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)).m_175362_(targetedFace.m_122434_()).m_122434_());
            }
            if (originalState.m_61138_(HorizontalKineticBlock.HORIZONTAL_FACING)) {
                return (BlockState)originalState.m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)originalState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_175362_(targetedFace.m_122434_()));
            }
        }
        if (originalState.m_61138_(RotatedPillarKineticBlock.AXIS)) {
            return (BlockState)originalState.m_61124_(RotatedPillarKineticBlock.AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)originalState.m_61143_(RotatedPillarKineticBlock.AXIS)).m_175362_(targetedFace.m_122434_()).m_122434_());
        }
        if (!originalState.m_61138_((Property)DirectionalKineticBlock.FACING)) {
            return originalState;
        }
        Direction stateFacing = (Direction)originalState.m_61143_((Property)DirectionalKineticBlock.FACING);
        if (stateFacing.m_122434_().equals((Object)targetedFace.m_122434_())) {
            if (originalState.m_61138_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) {
                return (BlockState)originalState.m_61122_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            }
            return originalState;
        }
        do {
            newState = (BlockState)newState.m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)((Direction)newState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_175362_(targetedFace.m_122434_()));
            if (targetedFace.m_122434_() != Direction.Axis.Y || !newState.m_61138_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) continue;
            newState = (BlockState)newState.m_61122_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
        } while (((Direction)newState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_().equals((Object)targetedFace.m_122434_()));
        return newState;
    }
}

