/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.decoration.copycat.CopycatStepBlock;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;

public class CopycatStepModel
extends CopycatModel {
    protected static final Vec3 VEC_Y_3 = new Vec3(0.0, 0.75, 0.0);
    protected static final Vec3 VEC_Y_2 = new Vec3(0.0, 0.5, 0.0);
    protected static final Vec3 VEC_Y_N2 = new Vec3(0.0, -0.5, 0.0);
    protected static final AABB CUBE_AABB = new AABB(BlockPos.f_121853_);

    public CopycatStepModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Override
    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, Random rand, BlockState material, IModelData wrappedData) {
        Direction facing = state.m_61145_((Property)CopycatStepBlock.FACING).orElse(Direction.SOUTH);
        boolean upperHalf = state.m_61145_(CopycatStepBlock.HALF).orElse(Half.BOTTOM) == Half.TOP;
        BakedModel model = CopycatStepModel.getModelOf(material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 normal = Vec3.m_82528_((Vec3i)facing.m_122436_());
        Vec3 normalScaled2 = normal.m_82490_(0.5);
        Vec3 normalScaledN3 = normal.m_82490_(-0.75);
        AABB bb = CUBE_AABB.m_82310_(-normal.f_82479_ * 0.75, 0.75, -normal.f_82481_ * 0.75);
        for (boolean top : Iterate.trueAndFalse) {
            for (boolean front : Iterate.trueAndFalse) {
                AABB bb1 = bb;
                if (front) {
                    bb1 = bb1.m_82383_(normalScaledN3);
                }
                if (top) {
                    bb1 = bb1.m_82383_(VEC_Y_3);
                }
                Vec3 offset = Vec3.f_82478_;
                if (front) {
                    offset = offset.m_82549_(normalScaled2);
                }
                if (top != upperHalf) {
                    offset = offset.m_82549_(upperHalf ? VEC_Y_2 : VEC_Y_N2);
                }
                for (int i = 0; i < size; ++i) {
                    BakedQuad quad = (BakedQuad)templateQuads.get(i);
                    Direction direction = quad.m_111306_();
                    if (front && direction == facing || !front && direction == facing.m_122424_() || !top && direction == Direction.UP || top && direction == Direction.DOWN) continue;
                    quads.add(BakedQuadHelper.cloneWithCustomGeometry(quad, BakedModelHelper.cropAndMove(quad.m_111303_(), quad.m_173410_(), bb1, offset)));
                }
            }
        }
        return quads;
    }
}

