/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.items.ItemHandlerHelper;

public class CopycatBlockEntity
extends SmartBlockEntity
implements ISpecialBlockEntityItemRequirement,
ITransformableBlockEntity,
IPartialSafeNBT {
    private BlockState material = AllBlocks.COPYCAT_BASE.getDefaultState();
    private ItemStack consumedItem = ItemStack.f_41583_;

    public CopycatBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockState getMaterial() {
        return this.material;
    }

    public boolean hasCustomMaterial() {
        return !AllBlocks.COPYCAT_BASE.has(this.getMaterial());
    }

    public void setMaterial(BlockState blockState) {
        BlockState wrapperState = this.m_58900_();
        if (!this.material.m_60713_(blockState.m_60734_())) {
            for (Direction side : Iterate.directions) {
                CopycatBlockEntity cbe;
                BlockState otherMaterial;
                BlockEntity blockEntity;
                BlockPos neighbour = this.f_58858_.m_142300_(side);
                BlockState neighbourState = this.f_58857_.m_8055_(neighbour);
                if (neighbourState != wrapperState || !((blockEntity = this.f_58857_.m_7702_(neighbour)) instanceof CopycatBlockEntity) || !(otherMaterial = (cbe = (CopycatBlockEntity)blockEntity).getMaterial()).m_60713_(blockState.m_60734_())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        this.material = blockState;
        if (!this.f_58857_.m_5776_()) {
            this.notifyUpdate();
            return;
        }
        this.redraw();
    }

    public boolean cycleMaterial() {
        if (this.material.m_61138_((Property)TrapDoorBlock.f_57515_) && this.material.m_61145_((Property)TrapDoorBlock.f_57514_).orElse(false).booleanValue()) {
            this.setMaterial((BlockState)this.material.m_61122_((Property)TrapDoorBlock.f_57515_));
        } else if (this.material.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.setMaterial((BlockState)this.material.m_61122_((Property)BlockStateProperties.f_61372_));
        } else if (this.material.m_61138_((Property)BlockStateProperties.f_61374_)) {
            this.setMaterial((BlockState)this.material.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)this.material.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_()));
        } else if (this.material.m_61138_((Property)BlockStateProperties.f_61365_)) {
            this.setMaterial((BlockState)this.material.m_61122_((Property)BlockStateProperties.f_61365_));
        } else if (this.material.m_61138_((Property)BlockStateProperties.f_61364_)) {
            this.setMaterial((BlockState)this.material.m_61122_((Property)BlockStateProperties.f_61364_));
        } else if (this.material.m_61138_((Property)BlockStateProperties.f_61443_)) {
            this.setMaterial((BlockState)this.material.m_61122_((Property)BlockStateProperties.f_61443_));
        } else if (this.material.m_61138_((Property)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial((BlockState)this.material.m_61122_((Property)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    public ItemStack getConsumedItem() {
        return this.consumedItem;
    }

    public void setConsumedItem(ItemStack stack) {
        this.consumedItem = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        this.m_6596_();
    }

    private void redraw() {
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        if (this.consumedItem.m_41619_()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.consumedItem);
    }

    @Override
    public void transform(StructureTransform transform) {
        this.material = transform.apply(this.material);
        this.notifyUpdate();
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.consumedItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        BlockState prevMaterial = this.material;
        if (!tag.m_128441_("Material")) {
            this.consumedItem = ItemStack.f_41583_;
            return;
        }
        this.material = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("Material"));
        if (this.material != null && !clientPacket) {
            BlockState blockState = this.m_58900_();
            if (blockState == null) {
                return;
            }
            Block block = blockState.m_60734_();
            if (!(block instanceof CopycatBlock)) {
                return;
            }
            CopycatBlock cb = (CopycatBlock)block;
            BlockState acceptedBlockState = cb.getAcceptedBlockState(this.f_58857_, this.f_58858_, this.consumedItem, null);
            if (acceptedBlockState != null && this.material.m_60713_(acceptedBlockState.m_60734_())) {
                return;
            }
            this.consumedItem = ItemStack.f_41583_;
            this.material = AllBlocks.COPYCAT_BASE.getDefaultState();
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        ItemStack stackWithoutNBT = this.consumedItem.m_41777_();
        stackWithoutNBT.m_41751_(null);
        this.write(tag, stackWithoutNBT, this.material);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.write(tag, this.consumedItem, this.material);
    }

    protected void write(CompoundTag tag, ItemStack stack, BlockState material) {
        tag.m_128365_("Item", (Tag)stack.serializeNBT());
        tag.m_128365_("Material", (Tag)NbtUtils.m_129202_((BlockState)material));
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(CopycatModel.MATERIAL_PROPERTY, (Object)this.material).build();
    }
}

