/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PulleyBlockEntity
extends LinearActuatorBlockEntity
implements ThresholdSwitchObservable {
    protected int initialOffset;
    private float prevAnimatedOffset;
    protected BlockPos mirrorParent;
    protected List<BlockPos> mirrorChildren;
    public WeakReference<AbstractContraptionEntity> sharedMirrorContraption;

    public PulleyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        AbstractContraptionEntity ace;
        double expandY = -this.offset;
        if (this.sharedMirrorContraption != null && (ace = (AbstractContraptionEntity)((Object)this.sharedMirrorContraption.get())) != null) {
            expandY = ace.m_20186_() - (double)this.f_58858_.m_123342_();
        }
        return super.createRenderBoundingBox().m_82363_(0.0, expandY, 0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.PULLEY_MAXED);
    }

    @Override
    public void tick() {
        float prevOffset = this.offset;
        super.tick();
        if (this.f_58857_.m_5776_() && this.mirrorParent != null && (this.sharedMirrorContraption == null || this.sharedMirrorContraption.get() == null || !((AbstractContraptionEntity)((Object)this.sharedMirrorContraption.get())).m_6084_())) {
            this.sharedMirrorContraption = null;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.mirrorParent);
            if (blockEntity instanceof PulleyBlockEntity) {
                PulleyBlockEntity pte = (PulleyBlockEntity)blockEntity;
                if (pte.movedContraption != null) {
                    this.sharedMirrorContraption = new WeakReference<AbstractContraptionEntity>(pte.movedContraption);
                }
            }
        }
        if (this.isVirtual()) {
            this.prevAnimatedOffset = this.offset;
        }
        this.invalidateRenderBoundingBox();
        if (prevOffset < 200.0f && this.offset >= 200.0f) {
            this.award(AllAdvancements.PULLEY_MAXED);
        }
    }

    @Override
    protected boolean isPassive() {
        return this.mirrorParent != null;
    }

    @Nullable
    public AbstractContraptionEntity getAttachedContraption() {
        return this.mirrorParent != null && this.sharedMirrorContraption != null ? (AbstractContraptionEntity)((Object)this.sharedMirrorContraption.get()) : this.movedContraption;
    }

    @Override
    protected void assemble() throws AssemblyException {
        BlockPos ropePos;
        BlockState ropeState;
        int i;
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof PulleyBlock)) {
            return;
        }
        if (this.speed == 0.0f && this.mirrorParent == null) {
            return;
        }
        int maxLength = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        for (i = 1; i <= maxLength && (AllBlocks.ROPE.has(ropeState = this.f_58857_.m_8055_(ropePos = this.f_58858_.m_6625_(i))) || AllBlocks.PULLEY_MAGNET.has(ropeState)); ++i) {
        }
        this.offset = i - 1;
        if (this.offset >= (float)this.getExtensionRange() && this.getSpeed() > 0.0f) {
            return;
        }
        if (this.offset <= 0.0f && this.getSpeed() < 0.0f) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.mirrorParent == null) {
            this.needsContraption = false;
            BlockPos anchor = this.f_58858_.m_6625_(Mth.m_14143_((float)(this.offset + 1.0f)));
            this.initialOffset = Mth.m_14143_((float)this.offset);
            PulleyContraption contraption = new PulleyContraption(this.initialOffset);
            boolean canAssembleStructure = contraption.assemble(this.f_58857_, anchor);
            if (canAssembleStructure) {
                Direction movementDirection;
                Direction direction = movementDirection = this.getSpeed() > 0.0f ? Direction.DOWN : Direction.UP;
                if (ContraptionCollider.isCollidingWithWorld(this.f_58857_, contraption, anchor.m_142300_(movementDirection), movementDirection)) {
                    canAssembleStructure = false;
                }
            }
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            this.removeRopes();
            if (!contraption.getBlocks().isEmpty()) {
                contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
                this.movedContraption = ControlledContraptionEntity.create(this.f_58857_, this, contraption);
                this.movedContraption.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
                this.f_58857_.m_7967_((Entity)this.movedContraption);
                this.forceMove = true;
                this.needsContraption = true;
                if (contraption.containsBlockBreakers()) {
                    this.award(AllAdvancements.CONTRAPTION_ACTORS);
                }
                for (BlockPos pos : contraption.createColliders(this.f_58857_, Direction.UP)) {
                    BlockEntity blockEntity;
                    if (pos.m_123342_() != 0 || !((blockEntity = this.f_58857_.m_7702_(new BlockPos((pos = pos.m_141952_((Vec3i)anchor)).m_123341_(), this.f_58858_.m_123342_(), pos.m_123343_()))) instanceof PulleyBlockEntity)) continue;
                    PulleyBlockEntity pbe = (PulleyBlockEntity)blockEntity;
                    pbe.startMirroringOther(this.f_58858_);
                }
            }
        }
        if (this.mirrorParent != null) {
            this.removeRopes();
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    private void removeRopes() {
        for (int i = (int)this.offset; i > 0; --i) {
            BlockPos offset = this.f_58858_.m_6625_(i);
            BlockState oldState = this.f_58857_.m_8055_(offset);
            this.f_58857_.m_7731_(offset, oldState.m_60819_().m_76188_(), 66);
        }
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null && this.mirrorParent == null) {
            return;
        }
        this.offset = this.getGridOffset(this.offset);
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
        }
        if (!this.f_58857_.f_46443_) {
            if (this.shouldCreateRopes()) {
                if (this.offset > 0.0f) {
                    BlockPos magnetPos = this.f_58858_.m_6625_((int)this.offset);
                    FluidState ifluidstate = this.f_58857_.m_6425_(magnetPos);
                    if (this.f_58857_.m_8055_(magnetPos).m_60800_((BlockGetter)this.f_58857_, magnetPos) != -1.0f) {
                        this.f_58857_.m_46961_(magnetPos, this.f_58857_.m_8055_(magnetPos).m_60812_((BlockGetter)this.f_58857_, magnetPos).m_83281_());
                        this.f_58857_.m_7731_(magnetPos, (BlockState)AllBlocks.PULLEY_MAGNET.getDefaultState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_)), 66);
                    }
                }
                boolean[] waterlog = new boolean[(int)this.offset];
                for (boolean destroyPass : Iterate.trueAndFalse) {
                    for (int i = 1; i <= (int)this.offset - 1; ++i) {
                        BlockPos ropePos = this.f_58858_.m_6625_(i);
                        if (this.f_58857_.m_8055_(ropePos).m_60800_((BlockGetter)this.f_58857_, ropePos) == -1.0f) continue;
                        if (destroyPass) {
                            FluidState ifluidstate = this.f_58857_.m_6425_(ropePos);
                            waterlog[i] = ifluidstate.m_76152_() == Fluids.f_76193_;
                            this.f_58857_.m_46961_(ropePos, this.f_58857_.m_8055_(ropePos).m_60812_((BlockGetter)this.f_58857_, ropePos).m_83281_());
                            continue;
                        }
                        this.f_58857_.m_7731_(this.f_58858_.m_6625_(i), (BlockState)AllBlocks.ROPE.getDefaultState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlog[i])), 66);
                    }
                }
            }
            if (this.movedContraption != null && this.mirrorParent == null) {
                this.movedContraption.disassemble();
            }
            this.notifyMirrorsOfDisassembly();
        }
        if (this.movedContraption != null) {
            this.movedContraption.m_146870_();
        }
        this.movedContraption = null;
        this.initialOffset = 0;
        this.running = false;
        this.sendData();
    }

    protected boolean shouldCreateRopes() {
        return !this.f_58859_;
    }

    @Override
    protected Vec3 toPosition(float offset) {
        if (this.movedContraption.getContraption() instanceof PulleyContraption) {
            PulleyContraption contraption = (PulleyContraption)this.movedContraption.getContraption();
            return Vec3.m_82528_((Vec3i)contraption.anchor).m_82520_(0.0, (double)((float)contraption.getInitialOffset() - offset), 0.0);
        }
        return Vec3.f_82478_;
    }

    @Override
    protected void visitNewPosition() {
        super.visitNewPosition();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.movedContraption != null) {
            return;
        }
        if (this.getSpeed() <= 0.0f) {
            return;
        }
        BlockPos posBelow = this.f_58858_.m_6625_((int)(this.offset + this.getMovementSpeed()) + 1);
        BlockState state = this.f_58857_.m_8055_(posBelow);
        if (!BlockMovementChecks.isMovementNecessary(state, this.f_58857_, posBelow)) {
            return;
        }
        if (BlockMovementChecks.isBrittle(state)) {
            return;
        }
        this.disassemble();
        this.assembleNextTick = true;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.initialOffset = compound.m_128451_("InitialOffset");
        this.needsContraption = compound.m_128471_("NeedsContraption");
        super.read(compound, clientPacket);
        BlockPos prevMirrorParent = this.mirrorParent;
        this.mirrorParent = null;
        this.mirrorChildren = null;
        if (compound.m_128441_("MirrorParent")) {
            this.mirrorParent = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("MirrorParent"));
            this.offset = 0.0f;
            if (prevMirrorParent == null || !prevMirrorParent.equals((Object)this.mirrorParent)) {
                this.sharedMirrorContraption = null;
            }
        }
        if (compound.m_128441_("MirrorChildren")) {
            this.mirrorChildren = NBTHelper.readCompoundList(compound.m_128437_("MirrorChildren", 10), NbtUtils::m_129239_);
        }
        if (this.mirrorParent == null) {
            this.sharedMirrorContraption = null;
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("InitialOffset", this.initialOffset);
        super.write(compound, clientPacket);
        if (this.mirrorParent != null) {
            compound.m_128365_("MirrorParent", (Tag)NbtUtils.m_129224_((BlockPos)this.mirrorParent));
        }
        if (this.mirrorChildren != null) {
            compound.m_128365_("MirrorChildren", (Tag)NBTHelper.writeCompoundList(this.mirrorChildren, NbtUtils::m_129224_));
        }
    }

    public void startMirroringOther(BlockPos parent) {
        if (parent.equals((Object)this.f_58858_)) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(parent);
        if (!(blockEntity instanceof PulleyBlockEntity)) {
            return;
        }
        PulleyBlockEntity pbe = (PulleyBlockEntity)blockEntity;
        if (pbe.m_58903_() != this.m_58903_()) {
            return;
        }
        if (pbe.mirrorChildren == null) {
            pbe.mirrorChildren = new ArrayList<BlockPos>();
        }
        pbe.mirrorChildren.add(this.f_58858_);
        pbe.notifyUpdate();
        this.mirrorParent = parent;
        try {
            this.assemble();
        }
        catch (AssemblyException assemblyException) {
            // empty catch block
        }
        this.notifyUpdate();
    }

    public void notifyMirrorsOfDisassembly() {
        if (this.mirrorChildren == null) {
            return;
        }
        for (BlockPos blockPos : this.mirrorChildren) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
            if (!(blockEntity instanceof PulleyBlockEntity)) continue;
            PulleyBlockEntity pbe = (PulleyBlockEntity)blockEntity;
            pbe.offset = this.offset;
            pbe.disassemble();
            pbe.mirrorParent = null;
            pbe.notifyUpdate();
        }
        this.mirrorChildren.clear();
        this.notifyUpdate();
    }

    @Override
    protected int getExtensionRange() {
        return Math.max(0, Math.min((Integer)AllConfigs.server().kinetics.maxRopeLength.get(), this.f_58858_.m_123342_() - 1 - this.f_58857_.m_141937_()));
    }

    @Override
    protected int getInitialOffset() {
        return this.initialOffset;
    }

    @Override
    protected Vec3 toMotionVector(float speed) {
        return new Vec3(0.0, (double)(-speed), 0.0);
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new CenteredSideValueBoxTransform((state, d) -> d == Direction.UP);
    }

    @Override
    public float getInterpolatedOffset(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)partialTicks, (float)this.prevAnimatedOffset, (float)this.offset);
        }
        boolean moving = this.running && (this.movedContraption == null || !this.movedContraption.isStalled());
        return super.getInterpolatedOffset(moving ? partialTicks : 0.5f);
    }

    public void animateOffset(float forcedOffset) {
        this.offset = forcedOffset;
    }

    @Override
    public float getPercent() {
        int distance = this.f_58858_.m_123342_() - this.f_58857_.m_141937_();
        if (distance <= 0) {
            return 100.0f;
        }
        return 100.0f * this.getInterpolatedOffset(0.5f) / (float)distance;
    }

    public BlockPos getMirrorParent() {
        return this.mirrorParent;
    }
}

