/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks.setup;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.recipes.DelegateRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.labellum.mc.waterflasks.setup.Registration;

public class HealFlaskRecipe
extends DelegateRecipe<IShapedRecipe<CraftingContainer>, CraftingContainer>
implements CraftingRecipe {
    protected HealFlaskRecipe(ResourceLocation id, IShapedRecipe<CraftingContainer> recipe) {
        super(id, recipe);
    }

    public ItemStack assemble(CraftingContainer inv) {
        FluidStack fluid = FluidStack.EMPTY;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!Helpers.isItem((ItemStack)stack, Registration.FLASKS)) continue;
            fluid = stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).orElse(FluidStack.EMPTY);
            break;
        }
        ItemStack result = super.m_5874_((Container)inv);
        if (!fluid.isEmpty()) {
            FluidStack fillFluid = fluid;
            result.getCapability(Capabilities.FLUID_ITEM).ifPresent(cap -> cap.fill(fillFluid, IFluidHandler.FluidAction.EXECUTE));
        }
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList items = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!stack.m_41763_() || !Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.KNIVES)) continue;
            items.set(i, (Object)Helpers.damageCraftingItem((ItemStack)stack, (int)1).m_41777_());
        }
        return items;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.HEAL_FLASK_SERIALIZER.get();
    }
}

