/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks.item;

import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.DiscreteFluidContainerItem;
import net.dries007.tfc.util.Drinkable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.labellum.mc.waterflasks.ConfigFlasks;
import org.labellum.mc.waterflasks.fluids.FlaskFluidHandler;
import org.labellum.mc.waterflasks.setup.Registration;

public class FlaskItem
extends DiscreteFluidContainerItem {
    public static final int DEFAULT_DRINK = 100;
    public static final TagKey<Fluid> DRINKABLE = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)Helpers.identifier((String)"usable_in_jug"));
    private final Supplier<Integer> capacity;
    private final Supplier<? extends Item> broken;
    private final int drink;

    public FlaskItem(Item.Properties prop, Supplier<Integer> capFunc, int drink, Supplier<? extends Item> broken) {
        super(prop, capFunc, DRINKABLE, false, false);
        this.capacity = capFunc;
        this.drink = drink;
        this.broken = broken;
    }

    public static int getCapacity(ItemStack stack) {
        return ((FlaskItem)stack.m_41720_()).capacity.get();
    }

    public static float getEmptinessDisplay(ItemStack stack) {
        return 1.0f - (float)FlaskItem.getLiquidAmount(stack) / (float)FlaskItem.getCapacity(stack);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new FlaskFluidHandler(stack, this.capacity.get(), DRINKABLE);
    }

    public static int getLiquidAmount(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.getFluidInTank(0).getAmount()).orElse(0);
    }

    public int m_142159_(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> {
            FluidStack drained = cap.drain(this.capacity.get().intValue(), IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty()) {
                return drained.getFluid().getAttributes().getColor();
            }
            return super.m_142159_(stack);
        }).orElse(super.m_142159_(stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        IFluidHandler handler = (IFluidHandler)Helpers.getCapability((ICapabilityProvider)stack, (Capability)Capabilities.FLUID_ITEM);
        if (handler == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_7500_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6047_()) {
            handler.drain(this.capacity.get().intValue(), IFluidHandler.FluidAction.EXECUTE);
            Helpers.playSound((Level)level, (BlockPos)player.m_142538_(), (SoundEvent)SoundEvents.f_11778_);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        BlockHitResult hit = Helpers.rayTracePlayer((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (FluidHelpers.transferBetweenWorldAndItem((ItemStack)stack, (Level)level, (BlockHitResult)hit, (Player)player, (InteractionHand)hand, (boolean)false, (boolean)false, (boolean)true)) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        if (handler.getFluidInTank(0).isEmpty()) {
            return this.afterFillFailed(handler, level, player, stack, hand);
        }
        FoodData stats = player.m_36324_();
        if (!((Boolean)ConfigFlasks.THIRSTY_DRINK.get()).booleanValue() && stats instanceof TFCFoodData && ((TFCFoodData)stats).getThirst() >= 100.0f) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        FluidStack cont = handler.drain(this.capacity.get().intValue(), IFluidHandler.FluidAction.SIMULATE);
        if (!cont.isEmpty() && cont.getAmount() >= this.drink) {
            return this.afterEmptyFailed(handler, level, player, stack, hand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            stack.getCapability(Capabilities.FLUID_ITEM).ifPresent(handler -> {
                FluidStack drained = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (drained.getAmount() >= this.drink) {
                    FluidStack fluidConsumed = handler.drain(this.drink, IFluidHandler.FluidAction.EXECUTE);
                    Drinkable drinkable = Drinkable.get((Fluid)fluidConsumed.getFluid());
                    if (drinkable != null) {
                        drinkable.onDrink(player, fluidConsumed.getAmount());
                    }
                    stack.m_41622_(1, (LivingEntity)player, p -> {
                        p.m_21190_(player.m_7655_());
                        level.m_5594_(null, entity.m_20097_(), (SoundEvent)Registration.FLASK_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        ItemHandlerHelper.giveItemToPlayer((Player)((Player)entity), (ItemStack)new ItemStack((ItemLike)this.broken.get()));
                    });
                }
            });
        }
        return stack;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack items = new ItemStack((ItemLike)this);
        items.m_41721_(stack.m_41773_());
        return items;
    }

    @NotNull
    protected InteractionResultHolder<ItemStack> afterEmptyFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        if (player.m_6047_()) {
            level.m_5594_(player, player.m_142538_(), SoundEvents.f_11778_, SoundSource.PLAYERS, 0.5f, 1.2f);
            handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        Drinkable drinkable = Drinkable.get((Fluid)handler.getFluidInTank(0).getFluid());
        if (drinkable != null) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (this.m_41389_(category)) {
            items.add((Object)new ItemStack((ItemLike)this));
            Iterator iterator = Helpers.getAllTagValues(DRINKABLE, (IForgeRegistry)ForgeRegistries.FLUIDS).iterator();
            while (true) {
                FlowingFluid flowing;
                if (!iterator.hasNext()) {
                    return;
                }
                Fluid fluid = (Fluid)iterator.next();
                if (fluid instanceof FlowingFluid && (flowing = (FlowingFluid)fluid).m_5613_() != flowing) continue;
                ItemStack stack = new ItemStack((ItemLike)this);
                Fluid finalFluid = fluid;
                stack.getCapability(Capabilities.FLUID_ITEM).ifPresent(c -> c.fill(new FluidStack(finalFluid, this.capacity.get().intValue()), IFluidHandler.FluidAction.EXECUTE));
                items.add((Object)stack);
            }
        }
    }
}

