/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSource;

public final class SurfaceManager {
    private final long seed;
    private final Map<BiomeExtension, SurfaceBuilder> builders;

    private static Map<BiomeExtension, SurfaceBuilder> collectSurfaceBuilders(long seed) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BiomeExtension variant : TFCBiomes.getExtensions()) {
            builder.put((Object)variant, (Object)variant.createSurfaceBuilder(seed));
        }
        return builder.build();
    }

    public SurfaceManager(long seed) {
        this.seed = seed;
        this.builders = SurfaceManager.collectSurfaceBuilders(seed);
    }

    public void buildSurface(LevelAccessor world, ChunkAccess chunk, RockLayerSettings rockLayerSettings, ChunkData chunkData, Biome[] accurateChunkBiomes, double[] accurateChunkBiomeWeights, double[] slopeMap, RandomSource random, int seaLevel, int minY) {
        boolean debugSlope = false;
        ChunkPos chunkPos = chunk.m_7697_();
        int blockX = chunkPos.m_45604_();
        int blockZ = chunkPos.m_45605_();
        SurfaceBuilderContext context = new SurfaceBuilderContext(world, chunk, chunkData, random, this.seed, rockLayerSettings, seaLevel, minY);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, x, z) + 1;
                double slope = this.sampleSlope(slopeMap, x, z);
                Biome biome = accurateChunkBiomes[x + 16 * z];
                double weight = accurateChunkBiomeWeights[x + 16 * z];
                BiomeExtension variants = TFCBiomes.getExtensionOrThrow(world, biome);
                SurfaceBuilder builder = this.builders.get(variants);
                context.buildSurface(biome, weight, variants.isSalty(), builder, blockX + x, y, blockZ + z, slope);
            }
        }
    }

    private double sampleSlope(double[] slopeMap, int x, int z) {
        int offsetX = x + 2;
        int offsetZ = z + 2;
        int cellX = offsetX >> 2;
        int cellZ = offsetZ >> 2;
        double deltaX = ((double)offsetX - (double)(cellX << 2)) * 0.25;
        double deltaZ = ((double)offsetZ - (double)(cellZ << 2)) * 0.25;
        double slope = 0.0;
        slope += slopeMap[cellX + 0 + 6 * (cellZ + 0)] * (1.0 - deltaX) * (1.0 - deltaZ);
        slope += slopeMap[cellX + 1 + 6 * (cellZ + 0)] * deltaX * (1.0 - deltaZ);
        slope += slopeMap[cellX + 0 + 6 * (cellZ + 1)] * (1.0 - deltaX) * deltaZ;
        slope += slopeMap[cellX + 1 + 6 * (cellZ + 1)] * deltaX * deltaZ;
        return slope *= (double)0.8f;
    }

    private void slopeVisualization(ChunkAccess chunk, double[] slopeMap, int chunkX, int chunkZ) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Block[] meter = new Block[]{Blocks.f_50147_, Blocks.f_50208_, Blocks.f_50203_, Blocks.f_50211_, Blocks.f_50209_, Blocks.f_50213_, Blocks.f_50205_, Blocks.f_50204_, Blocks.f_50148_, Blocks.f_50214_, Blocks.f_50202_, Blocks.f_50206_};
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
                mutablePos.m_122178_(chunkX + x, y, chunkZ + z);
                double slope = this.sampleSlope(slopeMap, x, z);
                int slopeIndex = Mth.m_14045_((int)((int)slope), (int)0, (int)(meter.length - 1));
                chunk.m_6978_((BlockPos)mutablePos, meter[slopeIndex].m_49966_(), false);
            }
        }
    }
}

