/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.RiverHelpers;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.RandomSource;

public class RiverFractal {
    private static final float MIN_BRANCH_ANGLE = 0.4f;
    private final List<Edge> edges;
    private final List<MidpointFractal> fractals;

    public static RiverFractal build(RandomSource random, float drainX, float drainY, float angle, float length, int depth, float feather) {
        return new Builder(random, drainX, drainY, angle, length, depth, feather).buildUntilCompletion().finish();
    }

    public static float distance(Edge edge, float px, float py) {
        return RiverHelpers.distancePointToLineSq(edge.source.x, edge.source.y, edge.drain.x, edge.drain.y, px, py);
    }

    private static float distance(Edge edge, Vertex vertex) {
        return RiverHelpers.distancePointToLineSq(edge.source.x, edge.source.y, edge.drain.x, edge.drain.y, vertex.x, vertex.y);
    }

    private static boolean intersect(Vertex p1, Vertex q1, Vertex p2, Vertex q2) {
        int o1 = RiverFractal.orientation(p1, q1, p2);
        int o2 = RiverFractal.orientation(p1, q1, q2);
        int o3 = RiverFractal.orientation(p2, q2, p1);
        int o4 = RiverFractal.orientation(p2, q2, q1);
        return o1 != o2 && o3 != o4 || o1 == 0 && RiverFractal.intersectCollinear(p1, p2, q1) || o2 == 0 && RiverFractal.intersectCollinear(p1, q2, q1) || o3 == 0 && RiverFractal.intersectCollinear(p2, p1, q2) || o4 == 0 && RiverFractal.intersectCollinear(p2, q1, q2);
    }

    private static boolean intersectCollinear(Vertex p, Vertex q, Vertex r) {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }

    private static int orientation(Vertex p, Vertex q, Vertex r) {
        float value = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
        if (value == 0.0f) {
            return 0;
        }
        return value > 0.0f ? 1 : 2;
    }

    public RiverFractal(List<Edge> edges, RandomSource random) {
        this.edges = edges;
        this.fractals = edges.stream().map(e -> e.fractal(random, 4)).toList();
    }

    public int hashCode() {
        return this.edges.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiverFractal other = (RiverFractal)o;
        return Objects.equals(this.edges, other.edges);
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public List<MidpointFractal> getFractals() {
        return this.fractals;
    }

    public static class Builder
    implements Context {
        private final Queue<Edge> branchQueue = new LinkedList<Edge>();
        private final RandomSource random;
        private final List<Edge> edges;
        private final Vertex root;
        private final List<Edge> branch;
        private final int depth;
        private final float featherSq;

        public Builder(RandomSource random, float drainX, float drainY, float angle, float length, int depth, float feather) {
            this.random = random;
            this.edges = new ArrayList<Edge>();
            this.root = new Vertex(drainX, drainY, angle, length, 0);
            this.branch = new ArrayList<Edge>();
            this.depth = depth;
            this.featherSq = feather * feather;
        }

        public Builder buildUntilCompletion() {
            this.buildInitialBranch(this);
            while (!this.buildBranch(this)) {
            }
            return this;
        }

        public boolean buildInitialBranch(Context context) {
            Vertex prev = this.root;
            int length = this.depth + this.random.nextInt(1 + (int)((float)this.depth * 0.3f));
            for (int i = 0; i < length; ++i) {
                Vertex next = this.computeNext(prev, prev.length, prev.distance);
                Edge nextEdge = new Edge(next, prev);
                if (context.intersectAny(nextEdge)) {
                    return i > 3;
                }
                this.edges.add(nextEdge);
                prev = next;
                if (prev.distance >= this.depth) continue;
                this.branchQueue.offer(nextEdge);
            }
            return true;
        }

        public boolean buildBranch(Context context) {
            Vertex next;
            Edge nextEdge;
            if (this.branchQueue.isEmpty()) {
                return true;
            }
            Edge prevEdge = this.branchQueue.poll();
            Vertex prev = prevEdge.drain;
            int prevDist = prev.distance + this.random.nextInt(3);
            Vertex branchNext = this.computeNext(prev, prev.length, prevDist);
            float deltaAngle = Math.abs(prevEdge.source.angle - branchNext.angle);
            if (deltaAngle < 0.4f || Math.PI * 2 - (double)deltaAngle < (double)0.4f) {
                return false;
            }
            this.branch.clear();
            Edge first = new Edge(branchNext, prev);
            if (context.intersectAny(first)) {
                return false;
            }
            this.branch.add(first);
            prev = branchNext;
            for (int i = 0; i < this.depth - prev.distance + this.random.nextInt(1 + (int)((float)this.depth * 0.3f)) && !context.intersectAny(nextEdge = new Edge(next = this.computeNext(prev, prev.length, prevDist), prev)); ++i) {
                this.branch.add(nextEdge);
                prev = next;
                prevDist = next.distance;
                if (prevDist >= this.depth) continue;
                this.branchQueue.offer(nextEdge);
            }
            this.edges.addAll(this.branch);
            return false;
        }

        public RiverFractal finish() {
            return new RiverFractal(this.edges, this.random);
        }

        @Override
        public boolean intersectAny(Edge edge) {
            for (Edge e : this.edges) {
                if (e.source == edge.drain || e.drain == edge.drain || !(RiverFractal.distance(e, edge.source) < this.featherSq) && !RiverFractal.intersect(e.source, e.drain, edge.source, edge.drain)) continue;
                return true;
            }
            return false;
        }

        private Vertex computeNext(Vertex prev, float length, int distance) {
            float nextAngle = prev.angle() + (this.random.nextFloat() * 0.5f + 0.2f) * (float)(this.random.nextBoolean() ? 1 : -1);
            float nextLength = length * (this.random.nextFloat() * 0.08f + 0.92f);
            float dx = Mth.m_14089_((float)nextAngle) * nextLength;
            float dy = Mth.m_14031_((float)nextAngle) * nextLength;
            float x = prev.x() + dx;
            float y = prev.y() + dy;
            return new Vertex(x, y, nextAngle, nextLength, distance + 1);
        }
    }

    public record Edge(Vertex source, Vertex drain) {
        public MidpointFractal fractal(RandomSource random, int bisections) {
            return new MidpointFractal(random, bisections, this.source.x, this.source.y, this.drain.x, this.drain.y);
        }
    }

    public record Vertex(float x, float y, float angle, float length, int distance) {
    }

    public static class MultiParallelBuilder
    implements Context {
        private final List<Builder> builders = new ArrayList<Builder>();

        public Context add(Builder builder) {
            this.builders.add(builder);
            return this;
        }

        public <E> List<E> buildEdges(Function<Edge, E> map) {
            return this.build().builders.stream().flatMap(e -> e.edges.stream().map(map)).toList();
        }

        public List<RiverFractal> buildFractals() {
            return this.build().builders.stream().map(Builder::finish).toList();
        }

        private MultiParallelBuilder build() {
            this.builders.removeIf(builder -> !builder.buildInitialBranch(this));
            ArrayList<Builder> working = new ArrayList<Builder>(this.builders);
            while (!working.isEmpty()) {
                working.removeIf(builder -> builder.buildBranch(this));
            }
            return this;
        }

        @Override
        public boolean intersectAny(Edge edge) {
            if (!this.isLegal(edge.drain, edge.source)) {
                return true;
            }
            for (Builder builder : this.builders) {
                if (!builder.intersectAny(edge)) continue;
                return true;
            }
            return false;
        }

        protected boolean isLegal(Vertex prev, Vertex vertex) {
            return true;
        }
    }

    public static interface Context {
        public boolean intersectAny(Edge var1);
    }
}

