/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.RiverFractal;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.RandomSource;
import org.jetbrains.annotations.Nullable;

public final class RiverEdge {
    private static final int MAX_AFFECTING_GRID_DISTANCE = 1 + Mth.m_14167_((float)4.05f);
    private final RiverFractal.Vertex sourceVertex;
    private final RiverFractal.Vertex drainVertex;
    private final MidpointFractal fractal;
    final int minPartX;
    final int minPartZ;
    final int maxPartX;
    final int maxPartZ;
    private boolean source;
    @Nullable
    private RiverEdge drainEdge;

    public RiverEdge(RiverFractal.Edge edge, RandomSource random) {
        this.sourceVertex = edge.source();
        this.drainVertex = edge.drain();
        this.fractal = edge.fractal(random, 4);
        int centerGridX = Math.round(0.5f * (edge.source().x() + edge.drain().x()));
        int centerGridZ = Math.round(0.5f * (edge.source().y() + edge.drain().y()));
        this.minPartX = Units.gridToPart(centerGridX - MAX_AFFECTING_GRID_DISTANCE);
        this.minPartZ = Units.gridToPart(centerGridZ - MAX_AFFECTING_GRID_DISTANCE);
        this.maxPartX = Units.gridToPart(centerGridX + MAX_AFFECTING_GRID_DISTANCE);
        this.maxPartZ = Units.gridToPart(centerGridZ + MAX_AFFECTING_GRID_DISTANCE);
    }

    public RiverFractal.Vertex source() {
        return this.sourceVertex;
    }

    public RiverFractal.Vertex drain() {
        return this.drainVertex;
    }

    public MidpointFractal fractal() {
        return this.fractal;
    }

    public boolean isSource() {
        return this.source;
    }

    public boolean isDrain() {
        return this.drainEdge == null;
    }

    public void setSource(boolean source) {
        this.source = source;
    }

    public void setDrainEdge(@Nullable RiverEdge drainEdge) {
        this.drainEdge = drainEdge;
    }
}

