/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum AnnotateDistanceToCellEdge implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet explored = new BitSet(region.sizeX() * region.sizeZ());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.maybeAt(dx + region.minX(), dz + region.minZ());
                if (point != null && !AnnotateDistanceToCellEdge.isUnbounded(region, dx, dz)) continue;
                explored.set(index);
                queue.enqueue(index);
                if (point == null) continue;
                point.distanceToEdge = (byte)-1;
            }
        }
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.data()[last];
            int nextDistance = lastPoint == null ? 0 : lastPoint.distanceToEdge + 1;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int next = region.offset(last, dx, dz);
                    if (next == -1) continue;
                    Region.Point point = region.data()[next];
                    if (point != null && point.distanceToEdge == 0 && !explored.get(next)) {
                        point.distanceToEdge = (byte)nextDistance;
                        explored.set(next);
                        queue.enqueue(next);
                    }
                    explored.set(next);
                }
            }
        }
    }

    private static boolean isUnbounded(Region region, int dx, int dz) {
        return dx == 0 || dz == 0 || dx == region.sizeX() - 1 || dz == region.sizeZ() - 1;
    }
}

