/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.Fluid;

public class ShallowWaterPlacement
extends PlacementModifier {
    public static final Codec<ShallowWaterPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.POSITIVE_INT.optionalFieldOf("max_depth", (Object)5).forGetter(c -> c.maxDepth)).apply((Applicative)instance, ShallowWaterPlacement::new));
    private final int maxDepth;

    public ShallowWaterPlacement(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public Stream<BlockPos> m_183381_(PlacementContext ctx, Random rand, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int i = 0; i < this.maxDepth; ++i) {
            mutablePos.m_122173_(Direction.DOWN);
            if (ctx.m_191831_().m_142433_((BlockPos)mutablePos, state -> Helpers.isFluid(state, (TagKey<Fluid>)FluidTags.f_13131_))) continue;
            return (double)rand.nextFloat() > (double)i / (double)this.maxDepth ? Stream.of(pos) : Stream.empty();
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFCPlacements.SHALLOW_WATER.get();
    }
}

