/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.Fluids;

public class FlatEnoughPlacement
extends PlacementModifier {
    public static final Codec<FlatEnoughPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("flatness", (Object)Float.valueOf(0.5f)).forGetter(c -> Float.valueOf(c.flatness)), (App)Codecs.POSITIVE_INT.optionalFieldOf("radius", (Object)2).forGetter(c -> c.radius), (App)Codecs.POSITIVE_INT.optionalFieldOf("max_depth", (Object)4).forGetter(c -> c.maxDepth)).apply((Applicative)instance, FlatEnoughPlacement::new));
    private final float flatness;
    private final int radius;
    private final int maxDepth;

    public FlatEnoughPlacement(float flatness, int radius, int maxDepth) {
        this.flatness = flatness;
        this.radius = radius;
        this.maxDepth = maxDepth;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFCPlacements.FLAT_ENOUGH.get();
    }

    public Stream<BlockPos> m_183381_(PlacementContext context, Random random, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < this.maxDepth; ++y) {
            if (!this.isFlatEnough(context, pos, -y, mutablePos)) continue;
            return Stream.of(pos.m_142082_(0, -y, 0));
        }
        return Stream.empty();
    }

    private boolean isFlatEnough(PlacementContext level, BlockPos pos, int y, BlockPos.MutableBlockPos mutablePos) {
        int flatAmount = 0;
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                mutablePos.m_122190_((Vec3i)pos).m_122184_(x, y, z);
                BlockState stateAt = level.m_191828_((BlockPos)mutablePos);
                if (stateAt.m_60795_() || stateAt.m_60819_().m_76152_() != Fluids.f_76191_) continue;
                ++flatAmount;
            }
        }
        return (float)flatAmount / ((1.0f + (float)(2 * this.radius)) * (1.0f + (float)(2 * this.radius))) > this.flatness;
    }
}

